[![view on npm](http://img.shields.io/npm/v/react-essence.svg)](https://www.npmjs.org/package/react-essence)
[![view on npm](http://img.shields.io/npm/l/react-essence.svg)](https://www.npmjs.org/package/react-essence)
[![npm module downloads](http://img.shields.io/npm/dt/react-essence.svg)](https://www.npmjs.org/package/react-essence)
[![Dependency Status](https://david-dm.org/Evo-Forge/Essence.svg)](https://david-dm.org/Evo-Forge/Essence)

#[Essence](http://getessence.io/) - The Essential Material Design Framework

### About Essence
Essence is a CSS framework that implements the guidelines from [Google Material Design Specification](https://www.google.com/design/spec/material-design/introduction.html) using Facebook's [react.js library](https://facebook.github.io/react/). Use it to easily build super-fast and great looking web & mobile interfaces.

See [here](http://getessence.io/) what you can build with Essence and how to do it. We've got several examples that will help you get started.

### Installation
```
npm install react-essence
```

### Import components
```javascript
import AppBar from 'essence-appbar';
import BottomSheets from 'essence-bottomsheet';
import Btn from 'essence-button';
import Chip from 'essence-chip';
import {Card, CardHeader, CardContent, CardFooter} from 'essence-card';
import {Block, Text, Divider, Utils} from 'essence-core';
import DataTable from 'essence-data-table';
import Icon from 'essence-icon';
import Image from 'essence-image';
import Input from 'essence-input';
import {List, ListItem} from 'essence-list';
import Menu from 'essence-menu';
import Navigation from 'essence-navigation';
import Paper from 'essence-paper';
import Progress from 'essence-progress';
import Slider from 'essence-slider';
import SnackBar from 'essence-snackbar';
import Stepper from 'essence-stepper';
import Switch from 'essence-switch';
import Tab from 'essence-tab';
import Toast from 'essence-toast';
import ToolBar from 'essence-toolbar';
import Tooltip from 'essence-tooltip';
import TouchPad from 'essence-touchpad';
```
### How to use
Use the example or live example from each component page.

### About us
We are a team of front end developers with extensive experience in building highly desirable products for both large companies and startups alike here at [GetEssence.io](http://getessence.io/).

We're very fond of our UI/UX craft and we're constantly creating tools that allow us to work smarter and faster. Essence is one of those tools and we're happy to release it as open-source.

### License
Essence is [MIT licensed](./LICENSE).

Essence documentation is [Creative Commons licensed](./LICENSE-docs).
