"use strict";

exports.__esModule = true;
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var BareHighlight =
/*#__PURE__*/
function (_PureComponent) {
  _inheritsLoose(BareHighlight, _PureComponent);

  function BareHighlight() {
    var _temp, _this;

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return (_temp = _this = _PureComponent.call.apply(_PureComponent, [this].concat(args)) || this, _defineProperty(_assertThisInitialized(_assertThisInitialized(_this)), "state", {
      highlightedCode: null,
      language: null
    }), _temp) || _assertThisInitialized(_this);
  }

  var _proto = BareHighlight.prototype;

  _proto.componentDidMount = function componentDidMount() {
    this.highlightCode();
  };

  _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
    // If the text changed make sure to reset the state
    // This way we ensure that the new text is immediately displayed.
    if (prevProps.children !== this.props.children) {
      this.setState({
        highlightedCode: null,
        language: null
      });
      return;
    } // Do not call highlight.js if we already have highlighted code
    // If the children changed highlightedCode will be null


    if (this.state.highlightedCode) return;
    this.highlightCode();
  };

  _proto.getInitialCode = function getInitialCode() {
    var type = typeof this.props.children;

    if (type !== 'string') {
      throw new Error("Children of <Highlight> must be a string. '" + type + "' supplied");
    }

    return this.props.children;
  };

  _proto.getHighlightPromise = function getHighlightPromise() {
    var _this2 = this;

    var _this$props = this.props,
        highlightjs = _this$props.highlightjs,
        languages = _this$props.languages;
    return new Promise(function (resolve) {
      if (languages && languages.length === 1) {
        resolve(highlightjs.highlight(languages[0], _this2.getInitialCode()));
      } else {
        resolve(highlightjs.highlightAuto(_this2.getInitialCode(), languages));
      }
    });
  };

  _proto.highlightCode = function highlightCode() {
    var _this3 = this;

    var _this$props2 = this.props,
        languages = _this$props2.languages,
        worker = _this$props2.worker;

    if (worker) {
      worker.onmessage = function (event) {
        return _this3.setState({
          highlightedCode: event.data.value,
          language: event.data.language
        });
      };

      worker.postMessage({
        code: this.getInitialCode(),
        languages: languages
      });
    } else {
      this.getHighlightPromise().then(function (result) {
        return _this3.setState({
          highlightedCode: result.value,
          language: result.language
        });
      });
    }
  };

  _proto.render = function render() {
    var code = this.state.highlightedCode;
    var classes = (0, _classnames.default)(this.props.className, 'hljs', this.state.language);

    if (code) {
      return _react.default.createElement("pre", null, _react.default.createElement("code", {
        className: classes,
        dangerouslySetInnerHTML: {
          __html: code
        }
      }));
    }

    return _react.default.createElement("pre", null, _react.default.createElement("code", {
      className: classes
    }, this.getInitialCode()));
  };

  return BareHighlight;
}(_react.PureComponent);

exports.default = BareHighlight;

_defineProperty(BareHighlight, "defaultProps", {
  className: '',
  languages: [],
  worker: null
});

process.env.NODE_ENV !== "production" ? BareHighlight.propTypes = {
  children: _propTypes.default.string.isRequired,
  className: _propTypes.default.string,
  highlightjs: _propTypes.default.object.isRequired,
  // eslint-disable-line react/forbid-prop-types
  languages: _propTypes.default.arrayOf(_propTypes.default.string),
  worker: _propTypes.default.object // eslint-disable-line react/forbid-prop-types

} : void 0;