(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('react'), require('invariant'), require('@react-google-maps/marker-clusterer'), require('react-dom'), require('@react-google-maps/infobox')) :
  typeof define === 'function' && define.amd ? define(['exports', 'react', 'invariant', '@react-google-maps/marker-clusterer', 'react-dom', '@react-google-maps/infobox'], factory) :
  (global = global || self, factory(global.reactGoogleMapsApi = {}, global.React, global.invariant, global.markerClusterer, global.ReactDOM, global.infobox));
}(this, (function (exports, React, invariant, markerClusterer, ReactDOM, infobox) { 'use strict';

  invariant = invariant && Object.prototype.hasOwnProperty.call(invariant, 'default') ? invariant['default'] : invariant;

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _inheritsLoose(subClass, superClass) {
    subClass.prototype = Object.create(superClass.prototype);
    subClass.prototype.constructor = subClass;
    subClass.__proto__ = superClass;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  var MapContext =
  /*#__PURE__*/
  React.createContext(null);
  function useGoogleMap() {
    !!!React.useContext ?  invariant(false, 'useGoogleMap is React hook and requires React version 16.8+')  : void 0;
    var map = React.useContext(MapContext);
    !!!map ?  invariant(false, 'useGoogleMap needs a GoogleMap available up in the tree')  : void 0;
    return map;
  }

  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  var reduce = function reduce(obj, fn, acc) {
    return Object.keys(obj).reduce(function reducer(newAcc, key) {
      return fn(newAcc, obj[key], key);
    }, acc);
  };

  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  function forEach(obj, fn) {
    Object.keys(obj).forEach(function iterator(key) {
      return fn(obj[key], key);
    });
  }

  /* global google */
  var applyUpdaterToNextProps = function applyUpdaterToNextProps( // eslint-disable-next-line @typescript-eslint/no-explicit-any
  updaterMap, // eslint-disable-next-line @typescript-eslint/no-explicit-any
  prevProps, // eslint-disable-next-line @typescript-eslint/no-explicit-any
  nextProps, // eslint-disable-next-line @typescript-eslint/no-explicit-any
  instance // eslint-disable-next-line @typescript-eslint/no-explicit-any
  ) {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    var map = {}; // eslint-disable-next-line @typescript-eslint/no-explicit-any

    var iter = function iter(fn, key) {
      var nextValue = nextProps[key];

      if (nextValue !== prevProps[key]) {
        map[key] = nextValue;
        fn(instance, nextValue);
      }
    };

    forEach(updaterMap, iter);
    return map;
  };
  function registerEvents( // eslint-disable-next-line @typescript-eslint/no-explicit-any
  props, // eslint-disable-next-line @typescript-eslint/no-explicit-any
  instance, eventMap) {
    var registeredList = reduce(eventMap, function reducer(acc, googleEventName, // eslint-disable-next-line @typescript-eslint/no-explicit-any
    onEventName) {
      if (typeof props[onEventName] === 'function') {
        acc.push(google.maps.event.addListener(instance, googleEventName, props[onEventName]));
      }

      return acc;
    }, []);
    return registeredList;
  }

  function unregisterEvent(registered) {
    google.maps.event.removeListener(registered);
  }

  function unregisterEvents(events) {
    if (events === void 0) {
      events = [];
    }

    events.forEach(unregisterEvent);
  }
  function applyUpdatersToPropsAndRegisterEvents(_ref) {
    var updaterMap = _ref.updaterMap,
        eventMap = _ref.eventMap,
        prevProps = _ref.prevProps,
        nextProps = _ref.nextProps,
        instance = _ref.instance;
    var registeredEvents = registerEvents(nextProps, instance, eventMap);
    applyUpdaterToNextProps(updaterMap, prevProps, nextProps, instance);
    return registeredEvents;
  }

  var eventMap = {
    onDblClick: 'dblclick',
    onDragEnd: 'dragend',
    onDragStart: 'dragstart',
    onMapTypeIdChanged: 'maptypeid_changed',
    onMouseMove: 'mousemove',
    onMouseOut: 'mouseout',
    onMouseOver: 'mouseover',
    onMouseDown: 'mousedown',
    onMouseUp: 'mouseup',
    onRightClick: 'rightclick',
    onTilesLoaded: 'tilesloaded',
    onBoundsChanged: 'bounds_changed',
    onCenterChanged: 'center_changed',
    onClick: 'click',
    onDrag: 'drag',
    onHeadingChanged: 'heading_changed',
    onIdle: 'idle',
    onProjectionChanged: 'projection_changed',
    onResize: 'resize',
    onTiltChanged: 'tilt_changed',
    onZoomChanged: 'zoom_changed'
  };
  var updaterMap = {
    extraMapTypes: function extraMapTypes(map, extra) {
      extra.forEach(function forEachExtra(it, i) {
        map.mapTypes.set(String(i), it);
      });
    },
    center: function center(map, _center) {
      map.setCenter(_center);
    },
    clickableIcons: function clickableIcons(map, clickable) {
      map.setClickableIcons(clickable);
    },
    heading: function heading(map, _heading) {
      map.setHeading(_heading);
    },
    mapTypeId: function mapTypeId(map, _mapTypeId) {
      map.setMapTypeId(_mapTypeId);
    },
    options: function options(map, _options) {
      map.setOptions(_options);
    },
    streetView: function streetView(map, _streetView) {
      map.setStreetView(_streetView);
    },
    tilt: function tilt(map, _tilt) {
      map.setTilt(_tilt);
    },
    zoom: function zoom(map, _zoom) {
      map.setZoom(_zoom);
    }
  };
  var GoogleMap =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(GoogleMap, _React$PureComponent);

    function GoogleMap() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.state = {
        map: null
      };
      _this.registeredEvents = [];
      _this.mapRef = null;

      _this.getInstance = function () {
        if (_this.mapRef === null) {
          return null;
        }

        return new google.maps.Map(_this.mapRef, _this.props.options);
      };

      _this.panTo = function (latLng) {
        var map = _this.getInstance();

        if (map) {
          map.panTo(latLng);
        }
      };

      _this.setMapCallback = function () {
        if (_this.state.map !== null) {
          if (_this.props.onLoad) {
            _this.props.onLoad(_this.state.map);
          }
        }
      };

      _this.getRef = function (ref) {
        _this.mapRef = ref;
      };

      return _this;
    }

    var _proto = GoogleMap.prototype;

    _proto.componentDidMount = function componentDidMount() {
      var map = this.getInstance();
      this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
        updaterMap: updaterMap,
        eventMap: eventMap,
        prevProps: {},
        nextProps: this.props,
        instance: map
      });
      this.setState(function setMap() {
        return {
          map: map
        };
      }, this.setMapCallback);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      if (this.state.map !== null) {
        unregisterEvents(this.registeredEvents);
        this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
          updaterMap: updaterMap,
          eventMap: eventMap,
          prevProps: prevProps,
          nextProps: this.props,
          instance: this.state.map
        });
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.map !== null) {
        if (this.props.onUnmount) {
          this.props.onUnmount(this.state.map);
        }

        unregisterEvents(this.registeredEvents);
      }
    };

    _proto.render = function render() {
      return React.createElement("div", {
        id: this.props.id,
        ref: this.getRef,
        style: this.props.mapContainerStyle,
        className: this.props.mapContainerClassName
      }, React.createElement(MapContext.Provider, {
        value: this.state.map
      }, this.state.map !== null ? this.props.children : React.createElement(React.Fragment, null)));
    };

    return GoogleMap;
  }(React.PureComponent);

  var isBrowser = typeof document !== 'undefined';

  var injectScript = function injectScript(_ref) {
    var url = _ref.url,
        id = _ref.id;

    if (!isBrowser) {
      return Promise.reject(new Error('document is undefined'));
    }

    return new Promise(function injectScriptCallback(resolve, reject) {
      var existingScript = document.getElementById(id);
      var windowWithGoogleMap = window;

      if (existingScript) {
        // Same script id/url: keep same script
        var dataStateAttribute = existingScript.getAttribute('data-state');

        if (existingScript.src === url && dataStateAttribute !== 'error') {
          if (dataStateAttribute === 'ready') {
            return resolve(id);
          } else {
            var originalInitMap = windowWithGoogleMap.initMap;
            var originalErrorCallback = existingScript.onerror;

            windowWithGoogleMap.initMap = function initMap() {
              if (originalInitMap) {
                originalInitMap();
              }

              resolve(id);
            };

            existingScript.onerror = function (err) {
              if (originalErrorCallback) {
                originalErrorCallback(err);
              }

              reject(err);
            };

            return;
          }
        } // Same script id, but either
        // 1. requested URL is different
        // 2. script failed to load
        else {
            existingScript.remove();
          }
      }

      var script = document.createElement('script');
      script.type = 'text/javascript';
      script.src = url;
      script.id = id;
      script.async = true;

      script.onerror = function onerror(err) {
        script.setAttribute('data-state', 'error');
        reject(err);
      };

      windowWithGoogleMap.initMap = function onload() {
        script.setAttribute('data-state', 'ready');
        resolve(id);
      };

      document.head.appendChild(script);
    })["catch"](function (err) {
      console.error('injectScript error: ', err);
      throw err;
    });
  };

  var isRobotoStyle = function isRobotoStyle(element) {
    // roboto font download
    if (element.href && element.href.indexOf('https://fonts.googleapis.com/css?family=Roboto') === 0) {
      return true;
    } // roboto style elements


    if (element.tagName.toLowerCase() === 'style' && // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
    // @ts-ignore
    element.styleSheet && // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
    // @ts-ignore
    element.styleSheet.cssText && // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
    // @ts-ignore
    element.styleSheet.cssText.replace('\r\n', '').indexOf('.gm-style') === 0) {
      // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
      // @ts-ignore
      element.styleSheet.cssText = '';
      return true;
    } // roboto style elements for other browsers


    if (element.tagName.toLowerCase() === 'style' && element.innerHTML && element.innerHTML.replace('\r\n', '').indexOf('.gm-style') === 0) {
      element.innerHTML = '';
      return true;
    } // when google tries to add empty style


    if (element.tagName.toLowerCase() === 'style' && // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
    // @ts-ignore
    !element.styleSheet && !element.innerHTML) {
      return true;
    }

    return false;
  }; // Preventing the Google Maps library from downloading an extra font


  var preventGoogleFonts = function preventGoogleFonts() {
    // we override these methods only for one particular head element
    // default methods for other elements are not affected
    var head = document.getElementsByTagName('head')[0];
    var trueInsertBefore = head.insertBefore.bind(head); // TODO: adding return before reflect solves the TS issue
    // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
    // @ts-ignore

    head.insertBefore = function insertBefore(newElement, referenceElement) {
      if (!isRobotoStyle(newElement)) {
        Reflect.apply(trueInsertBefore, head, [newElement, referenceElement]);
      }
    };

    var trueAppend = head.appendChild.bind(head); // TODO: adding return before reflect solves the TS issue
    // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
    // @ts-ignore

    head.appendChild = function appendChild(textNode) {
      if (!isRobotoStyle(textNode)) {
        Reflect.apply(trueAppend, head, [textNode]);
      }
    };
  };

  function makeLoadScriptUrl(_ref) {
    var googleMapsApiKey = _ref.googleMapsApiKey,
        googleMapsClientId = _ref.googleMapsClientId,
        _ref$version = _ref.version,
        version = _ref$version === void 0 ? 'weekly' : _ref$version,
        language = _ref.language,
        region = _ref.region,
        libraries = _ref.libraries,
        channel = _ref.channel;
    var params = [];
    !(googleMapsApiKey && googleMapsClientId || !(googleMapsApiKey && googleMapsClientId)) ?  invariant(false, 'You need to specify either googleMapsApiKey or googleMapsClientId for @react-google-maps/api load script to work. You cannot use both at the same time.')  : void 0;

    if (googleMapsApiKey) {
      params.push("key=" + googleMapsApiKey);
    } else if (googleMapsClientId) {
      params.push("client=" + googleMapsClientId);
    }

    if (version) {
      params.push("v=" + version);
    }

    if (language) {
      params.push("language=" + language);
    }

    if (region) {
      params.push("region=" + region);
    }

    if (libraries && libraries.length) {
      params.push("libraries=" + libraries.sort().join(','));
    }

    if (channel) {
      params.push("channel=" + channel);
    }

    params.push('callback=initMap');
    return "https://maps.googleapis.com/maps/api/js?" + params.join('&');
  }

  var cleaningUp = false;
  function DefaultLoadingElement() {
    return React.createElement("div", null, "Loading...");
  }
  var defaultLoadScriptProps = {
    id: 'script-loader',
    version: 'weekly'
  };

  var LoadScript =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(LoadScript, _React$PureComponent);

    function LoadScript() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.check = React.createRef();
      _this.state = {
        loaded: false
      };

      _this.cleanupCallback = function () {
        delete window.google;

        _this.injectScript();
      };

      _this.isCleaningUp = function () {
        try {
          var promiseCallback = function promiseCallback(resolve) {
            if (!cleaningUp) {
              resolve();
            } else {
              if (isBrowser) {
                var timer = window.setInterval(function interval() {
                  if (!cleaningUp) {
                    window.clearInterval(timer);
                    resolve();
                  }
                }, 1);
              }
            }

            return;
          };

          return Promise.resolve(new Promise(promiseCallback));
        } catch (e) {
          return Promise.reject(e);
        }
      };

      _this.cleanup = function () {
        cleaningUp = true;
        var script = document.getElementById(_this.props.id);

        if (script && script.parentNode) {
          script.parentNode.removeChild(script);
        }

        Array.prototype.slice.call(document.getElementsByTagName('script')).filter(function filter(script) {
          return script.src.includes('maps.googleapis');
        }).forEach(function forEach(script) {
          if (script.parentNode) {
            script.parentNode.removeChild(script);
          }
        });
        Array.prototype.slice.call(document.getElementsByTagName('link')).filter(function filter(link) {
          return link.href === 'https://fonts.googleapis.com/css?family=Roboto:300,400,500,700|Google+Sans';
        }).forEach(function forEach(link) {
          if (link.parentNode) {
            link.parentNode.removeChild(link);
          }
        });
        Array.prototype.slice.call(document.getElementsByTagName('style')).filter(function filter(style) {
          return style.innerText !== undefined && style.innerText.length > 0 && style.innerText.includes('.gm-');
        }).forEach(function forEach(style) {
          if (style.parentNode) {
            style.parentNode.removeChild(style);
          }
        });
      };

      _this.injectScript = function () {
        if (_this.props.preventGoogleFontsLoading) {
          preventGoogleFonts();
        }

        !!!_this.props.id ?  invariant(false, 'LoadScript requires "id" prop to be a string: %s', _this.props.id)  : void 0;
        var injectScriptOptions = {
          id: _this.props.id,
          url: makeLoadScriptUrl(_this.props)
        };
        injectScript(injectScriptOptions).then(function () {
          if (_this.props.onLoad) {
            _this.props.onLoad();
          }

          _this.setState(function setLoaded() {
            return {
              loaded: true
            };
          });

          return;
        })["catch"](function (err) {
          if (_this.props.onError) {
            _this.props.onError(err);
          }

          console.error("\n          There has been an Error with loading Google Maps API script, please check that you provided correct google API key (" + (_this.props.googleMapsApiKey || '-') + ") or Client ID (" + (_this.props.googleMapsClientId || '-') + ") to <LoadScript />\n          Otherwise it is a Network issue.\n        ");
        });
      };

      return _this;
    }

    var _proto = LoadScript.prototype;

    _proto.componentDidMount = function componentDidMount() {
      if (isBrowser) {
        if (window.google && !cleaningUp) {
          console.error('google api is already presented');
          return;
        }

        this.isCleaningUp().then(this.injectScript)["catch"](function error(err) {
          console.error('Error at injecting script after cleaning up: ', err);
        });
      }
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      if (this.props.libraries !== prevProps.libraries) {
        console.warn('Performance warning! LoadScript has been reloaded unintentionally! You should not pass `libraries` prop as new array. Please keep an array of libraries as static class property for Components and PureComponents, or just a const variable outside of component, or somewhere in config files or ENV variables');
      }

      if (isBrowser && prevProps.language !== this.props.language) {
        this.cleanup(); // TODO: refactor to use gDSFP maybe... wait for hooks refactoring.
        // eslint-disable-next-line react/no-did-update-set-state

        this.setState(function setLoaded() {
          return {
            loaded: false
          };
        }, this.cleanupCallback);
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      var _this2 = this;

      if (isBrowser) {
        this.cleanup();

        var timeoutCallback = function timeoutCallback() {
          if (!_this2.check.current) {
            delete window.google;
            cleaningUp = false;
          }
        };

        window.setTimeout(timeoutCallback, 1);

        if (this.props.onUnmount) {
          this.props.onUnmount();
        }
      }
    };

    _proto.render = function render() {
      return React.createElement(React.Fragment, null, React.createElement("div", {
        ref: this.check
      }), this.state.loaded ? this.props.children : this.props.loadingElement || React.createElement(DefaultLoadingElement, null));
    };

    return LoadScript;
  }(React.PureComponent);

  LoadScript.defaultProps = defaultLoadScriptProps;

  /* eslint-disable filenames/match-regex */
  var previouslyLoadedUrl;
  function useLoadScript(_ref) {
    var _ref$id = _ref.id,
        id = _ref$id === void 0 ? defaultLoadScriptProps.id : _ref$id,
        _ref$version = _ref.version,
        version = _ref$version === void 0 ? defaultLoadScriptProps.version : _ref$version,
        googleMapsApiKey = _ref.googleMapsApiKey,
        googleMapsClientId = _ref.googleMapsClientId,
        language = _ref.language,
        region = _ref.region,
        libraries = _ref.libraries,
        preventGoogleFontsLoading = _ref.preventGoogleFontsLoading,
        channel = _ref.channel;
    var isMounted = React.useRef(false);

    var _React$useState = React.useState(false),
        isLoaded = _React$useState[0],
        setLoaded = _React$useState[1];

    var _React$useState2 = React.useState(undefined),
        loadError = _React$useState2[0],
        setLoadError = _React$useState2[1];

    React.useEffect(function trackMountedState() {
      isMounted.current = true;
      return function () {
        isMounted.current = false;
      };
    }, []);
    React.useEffect(function applyPreventGoogleFonts() {
      if (isBrowser && preventGoogleFontsLoading) {
        preventGoogleFonts();
      }
    }, [preventGoogleFontsLoading]);
    React.useEffect(function validateLoadedState() {
      if (isLoaded) {
        !!!window.google ?  invariant(false, 'useLoadScript was marked as loaded, but window.google is not present. Something went wrong.')  : void 0;
      }
    }, [isLoaded]);
    var url = makeLoadScriptUrl({
      version: version,
      googleMapsApiKey: googleMapsApiKey,
      googleMapsClientId: googleMapsClientId,
      language: language,
      region: region,
      libraries: libraries,
      channel: channel
    });
    React.useEffect(function loadScriptAndModifyLoadedState() {
      if (!isBrowser) {
        return;
      }

      function setLoadedIfMounted() {
        if (isMounted.current) {
          setLoaded(true);
          previouslyLoadedUrl = url;
        }
      }

      if (window.google && previouslyLoadedUrl === url) {
        setLoadedIfMounted();
        return;
      }

      injectScript({
        id: id,
        url: url
      }).then(setLoadedIfMounted)["catch"](function handleInjectError(err) {
        if (isMounted.current) {
          setLoadError(err);
        }

        console.warn("\n        There has been an Error with loading Google Maps API script, please check that you provided correct google API key (" + (googleMapsApiKey || '-') + ") or Client ID (" + (googleMapsClientId || '-') + ")\n        Otherwise it is a Network issue.\n      ");
        console.error(err);
      });
    }, [id, url]);
    var prevLibraries = React.useRef();
    React.useEffect(function checkPerformance() {
      if (prevLibraries.current && libraries !== prevLibraries.current) {
        console.warn('Performance warning! LoadScript has been reloaded unintentionally! You should not pass `libraries` prop as new array. Please keep an array of libraries as static class property for Components and PureComponents, or just a const variable outside of component, or somewhere in config files or ENV variables');
      }

      prevLibraries.current = libraries;
    }, [libraries]);
    return {
      isLoaded: isLoaded,
      loadError: loadError,
      url: url
    };
  }

  var defaultLoadingElement =
  /*#__PURE__*/
  React.createElement(DefaultLoadingElement, null);

  function LoadScriptNext(_ref) {
    var loadingElement = _ref.loadingElement,
        onLoad = _ref.onLoad,
        onError = _ref.onError,
        onUnmount = _ref.onUnmount,
        children = _ref.children,
        hookOptions = _objectWithoutPropertiesLoose(_ref, ["loadingElement", "onLoad", "onError", "onUnmount", "children"]);

    var _useLoadScript = useLoadScript(hookOptions),
        isLoaded = _useLoadScript.isLoaded,
        loadError = _useLoadScript.loadError;

    React.useEffect(function handleOnLoad() {
      if (isLoaded && typeof onLoad === 'function') {
        onLoad();
      }
    }, [isLoaded, onLoad]);
    React.useEffect(function handleOnError() {
      if (loadError && typeof onError === 'function') {
        onError(loadError);
      }
    }, [loadError, onError]);
    React.useEffect(function handleOnUnmount() {
      return function () {
        if (onUnmount) {
          onUnmount();
        }
      };
    }, [onUnmount]);
    return isLoaded ? children : loadingElement || defaultLoadingElement;
  }

  var LoadScriptNext$1 = /*#__PURE__*/
  React.memo(LoadScriptNext);

  var eventMap$1 = {};
  var updaterMap$1 = {
    options: function options(instance, _options) {
      instance.setOptions(_options);
    }
  };
  var TrafficLayer =
  /*#__PURE__*/
  function (_PureComponent) {
    _inheritsLoose(TrafficLayer, _PureComponent);

    function TrafficLayer() {
      var _this;

      _this = _PureComponent.apply(this, arguments) || this;
      _this.state = {
        trafficLayer: null
      };

      _this.setTrafficLayerCallback = function () {
        if (_this.state.trafficLayer !== null) {
          if (_this.props.onLoad) {
            // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
            // @ts-ignore
            _this.props.onLoad(_this.state.trafficLayer);
          }
        }
      };

      _this.registeredEvents = [];
      return _this;
    }

    var _proto = TrafficLayer.prototype;

    _proto.componentDidMount = function componentDidMount() {
      var trafficLayer = new google.maps.TrafficLayer(_extends({}, this.props.options || {}, {
        map: this.context
      }));
      this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
        updaterMap: updaterMap$1,
        eventMap: eventMap$1,
        prevProps: {},
        nextProps: this.props,
        instance: trafficLayer
      });
      this.setState(function setTrafficLayer() {
        return {
          trafficLayer: trafficLayer
        };
      }, this.setTrafficLayerCallback);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      if (this.state.trafficLayer !== null) {
        unregisterEvents(this.registeredEvents);
        this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
          updaterMap: updaterMap$1,
          eventMap: eventMap$1,
          prevProps: prevProps,
          nextProps: this.props,
          instance: this.state.trafficLayer
        });
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.trafficLayer !== null) {
        if (this.props.onUnmount) {
          // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
          // @ts-ignore
          this.props.onUnmount(this.state.trafficLayer);
        }

        unregisterEvents(this.registeredEvents); // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
        // @ts-ignore

        this.state.trafficLayer.setMap(null);
      }
    };

    _proto.render = function render() {
      return null;
    };

    return TrafficLayer;
  }(React.PureComponent);
  TrafficLayer.contextType = MapContext;

  var BicyclingLayer =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(BicyclingLayer, _React$PureComponent);

    function BicyclingLayer() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.state = {
        bicyclingLayer: null
      };

      _this.setBicyclingLayerCallback = function () {
        if (_this.state.bicyclingLayer !== null) {
          // TODO: how is this possibly null if we're doing a null check
          // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
          // @ts-ignore
          _this.state.bicyclingLayer.setMap(_this.context);

          if (_this.props.onLoad) {
            // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
            // @ts-ignore
            _this.props.onLoad(_this.state.bicyclingLayer);
          }
        }
      };

      return _this;
    }

    var _proto = BicyclingLayer.prototype;

    _proto.componentDidMount = function componentDidMount() {
      var bicyclingLayer = new google.maps.BicyclingLayer();
      this.setState(function setBicyclingLayer() {
        return {
          bicyclingLayer: bicyclingLayer
        };
      }, this.setBicyclingLayerCallback);
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.bicyclingLayer !== null) {
        if (this.props.onUnmount) {
          // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
          // @ts-ignore
          this.props.onUnmount(this.state.bicyclingLayer);
        } // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
        // @ts-ignore


        this.state.bicyclingLayer.setMap(null);
      }
    };

    _proto.render = function render() {
      return null;
    };

    return BicyclingLayer;
  }(React.PureComponent);
  BicyclingLayer.contextType = MapContext;

  var TransitLayer =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(TransitLayer, _React$PureComponent);

    function TransitLayer() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.state = {
        transitLayer: null
      };

      _this.setTransitLayerCallback = function () {
        if (_this.state.transitLayer !== null) {
          // TODO: how is this possibly null if we're doing a null check
          // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
          // @ts-ignore
          _this.state.transitLayer.setMap(_this.context);

          if (_this.props.onLoad) {
            // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
            // @ts-ignore
            _this.props.onLoad(_this.state.transitLayer);
          }
        }
      };

      return _this;
    }

    var _proto = TransitLayer.prototype;

    _proto.componentDidMount = function componentDidMount() {
      var transitLayer = new google.maps.TransitLayer();
      this.setState(function setTransitLayer() {
        return {
          transitLayer: transitLayer
        };
      }, this.setTransitLayerCallback);
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.transitLayer !== null) {
        if (this.props.onUnmount) {
          // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
          // @ts-ignore
          this.props.onUnmount(this.state.transitLayer);
        } // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
        // @ts-ignore


        this.state.transitLayer.setMap(null);
      }
    };

    _proto.render = function render() {
      return null;
    };

    return TransitLayer;
  }(React.PureComponent);
  TransitLayer.contextType = MapContext;

  var eventMap$2 = {
    onCircleComplete: 'circlecomplete',
    onMarkerComplete: 'markercomplete',
    onOverlayComplete: 'overlaycomplete',
    onPolygonComplete: 'polygoncomplete',
    onPolylineComplete: 'polylinecomplete',
    onRectangleComplete: 'rectanglecomplete'
  };
  var updaterMap$2 = {
    drawingMode: function drawingMode(instance, _drawingMode) {
      instance.setDrawingMode(_drawingMode);
    },
    options: function options(instance, _options) {
      instance.setOptions(_options);
    }
  };
  var DrawingManager =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(DrawingManager, _React$PureComponent);

    function DrawingManager(props) {
      var _this;

      _this = _React$PureComponent.call(this, props) || this;
      _this.registeredEvents = [];
      _this.state = {
        drawingManager: null
      };

      _this.setDrawingManagerCallback = function () {
        if (_this.state.drawingManager !== null && _this.props.onLoad) {
          _this.props.onLoad(_this.state.drawingManager);
        }
      };

      !!!google.maps.drawing ?  invariant(false, "Did you include prop libraries={['drawing']} in the URL? %s", google.maps.drawing)  : void 0;
      return _this;
    }

    var _proto = DrawingManager.prototype;

    _proto.componentDidMount = function componentDidMount() {
      var drawingManager = new google.maps.drawing.DrawingManager(_extends({}, this.props.options || {}, {
        map: this.context
      }));
      this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
        updaterMap: updaterMap$2,
        eventMap: eventMap$2,
        prevProps: {},
        nextProps: this.props,
        instance: drawingManager
      });
      this.setState(function setDrawingManager() {
        return {
          drawingManager: drawingManager
        };
      }, this.setDrawingManagerCallback);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      if (this.state.drawingManager !== null) {
        unregisterEvents(this.registeredEvents);
        this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
          updaterMap: updaterMap$2,
          eventMap: eventMap$2,
          prevProps: prevProps,
          nextProps: this.props,
          instance: this.state.drawingManager
        });
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.drawingManager !== null) {
        if (this.props.onUnmount) {
          this.props.onUnmount(this.state.drawingManager);
        }

        unregisterEvents(this.registeredEvents);
        this.state.drawingManager.setMap(null);
      }
    };

    _proto.render = function render() {
      return React.createElement(React.Fragment, null);
    };

    return DrawingManager;
  }(React.PureComponent);
  DrawingManager.contextType = MapContext;

  var eventMap$3 = {
    onAnimationChanged: 'animation_changed',
    onClick: 'click',
    onClickableChanged: 'clickable_changed',
    onCursorChanged: 'cursor_changed',
    onDblClick: 'dblclick',
    onDrag: 'drag',
    onDragEnd: 'dragend',
    onDraggableChanged: 'draggable_changed',
    onDragStart: 'dragstart',
    onFlatChanged: 'flat_changed',
    onIconChanged: 'icon_changed',
    onMouseDown: 'mousedown',
    onMouseOut: 'mouseout',
    onMouseOver: 'mouseover',
    onMouseUp: 'mouseup',
    onPositionChanged: 'position_changed',
    onRightClick: 'rightclick',
    onShapeChanged: 'shape_changed',
    onTitleChanged: 'title_changed',
    onVisibleChanged: 'visible_changed',
    onZindexChanged: 'zindex_changed'
  };
  var updaterMap$3 = {
    animation: function animation(instance, _animation) {
      instance.setAnimation(_animation);
    },
    clickable: function clickable(instance, _clickable) {
      instance.setClickable(_clickable);
    },
    cursor: function cursor(instance, _cursor) {
      instance.setCursor(_cursor);
    },
    draggable: function draggable(instance, _draggable) {
      instance.setDraggable(_draggable);
    },
    icon: function icon(instance, _icon) {
      instance.setIcon(_icon);
    },
    label: function label(instance, _label) {
      instance.setLabel(_label);
    },
    map: function map(instance, _map) {
      instance.setMap(_map);
    },
    opacity: function opacity(instance, _opacity) {
      instance.setOpacity(_opacity);
    },
    options: function options(instance, _options) {
      instance.setOptions(_options);
    },
    position: function position(instance, _position) {
      instance.setPosition(_position);
    },
    shape: function shape(instance, _shape) {
      instance.setShape(_shape);
    },
    title: function title(instance, _title) {
      instance.setTitle(_title);
    },
    visible: function visible(instance, _visible) {
      instance.setVisible(_visible);
    },
    zIndex: function zIndex(instance, _zIndex) {
      instance.setZIndex(_zIndex);
    }
  };
  var Marker =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(Marker, _React$PureComponent);

    function Marker() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.registeredEvents = [];
      _this.state = {
        marker: null
      };

      _this.setMarkerCallback = function () {
        if (_this.state.marker !== null && _this.props.onLoad) {
          _this.props.onLoad(_this.state.marker);
        }
      };

      return _this;
    }

    var _proto = Marker.prototype;

    _proto.componentDidMount = function componentDidMount() {
      var markerOptions = _extends({}, this.props.options || {}, {}, this.props.clusterer ? {} : {
        map: this.context
      }, {
        position: this.props.position
      });

      var marker = new google.maps.Marker(markerOptions);

      if (this.props.clusterer) {
        this.props.clusterer.addMarker( // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
        // @ts-ignore
        marker, !!this.props.noClustererRedraw);
      } else {
        marker.setMap(this.context);
      }

      this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
        updaterMap: updaterMap$3,
        eventMap: eventMap$3,
        prevProps: {},
        nextProps: this.props,
        instance: marker
      });
      this.setState(function setMarker() {
        return {
          marker: marker
        };
      }, this.setMarkerCallback);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      if (this.state.marker !== null) {
        unregisterEvents(this.registeredEvents);
        this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
          updaterMap: updaterMap$3,
          eventMap: eventMap$3,
          prevProps: prevProps,
          nextProps: this.props,
          instance: this.state.marker
        });
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.marker !== null) {
        if (this.props.onUnmount) {
          this.props.onUnmount(this.state.marker);
        }

        unregisterEvents(this.registeredEvents);

        if (this.props.clusterer) {
          this.props.clusterer.removeMarker( // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
          // @ts-ignore
          this.state.marker, !!this.props.noClustererRedraw);
        } else {
          this.state.marker && this.state.marker.setMap(null);
        }
      }
    };

    _proto.render = function render() {
      return this.props.children || null;
    };

    return Marker;
  }(React.PureComponent);
  Marker.contextType = MapContext;

  var eventMap$4 = {
    onClick: 'click',
    onClusteringBegin: 'clusteringbegin',
    onClusteringEnd: 'clusteringend',
    onMouseOut: 'mouseout',
    onMouseOver: 'mouseover'
  };
  var updaterMap$4 = {
    averageCenter: function averageCenter(instance, _averageCenter) {
      instance.setAverageCenter(_averageCenter);
    },
    batchSizeIE: function batchSizeIE(instance, _batchSizeIE) {
      instance.setBatchSizeIE(_batchSizeIE);
    },
    calculator: function calculator(instance, _calculator) {
      instance.setCalculator(_calculator);
    },
    clusterClass: function clusterClass(instance, _clusterClass) {
      instance.setClusterClass(_clusterClass);
    },
    enableRetinaIcons: function enableRetinaIcons(instance, _enableRetinaIcons) {
      instance.setEnableRetinaIcons(_enableRetinaIcons);
    },
    gridSize: function gridSize(instance, _gridSize) {
      instance.setGridSize(_gridSize);
    },
    ignoreHidden: function ignoreHidden(instance, _ignoreHidden) {
      instance.setIgnoreHidden(_ignoreHidden);
    },
    imageExtension: function imageExtension(instance, _imageExtension) {
      instance.setImageExtension(_imageExtension);
    },
    imagePath: function imagePath(instance, _imagePath) {
      instance.setImagePath(_imagePath);
    },
    imageSizes: function imageSizes(instance, _imageSizes) {
      instance.setImageSizes(_imageSizes);
    },
    maxZoom: function maxZoom(instance, _maxZoom) {
      instance.setMaxZoom(_maxZoom);
    },
    minimumClusterSize: function minimumClusterSize(instance, _minimumClusterSize) {
      instance.setMinimumClusterSize(_minimumClusterSize);
    },
    styles: function styles(instance, _styles) {
      instance.setStyles(_styles);
    },
    title: function title(instance, _title) {
      instance.setTitle(_title);
    },
    zoomOnClick: function zoomOnClick(instance, _zoomOnClick) {
      instance.setZoomOnClick(_zoomOnClick);
    }
  };
  var ClustererComponent =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(ClustererComponent, _React$PureComponent);

    function ClustererComponent() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.registeredEvents = [];
      _this.state = {
        markerClusterer: null
      };

      _this.setClustererCallback = function () {
        if (_this.state.markerClusterer !== null && _this.props.onLoad) {
          _this.props.onLoad(_this.state.markerClusterer);
        }
      };

      return _this;
    }

    var _proto = ClustererComponent.prototype;

    _proto.componentDidMount = function componentDidMount() {
      if (this.context) {
        var markerClusterer$1 = new markerClusterer.Clusterer(this.context, [], this.props.options);
        this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
          updaterMap: updaterMap$4,
          eventMap: eventMap$4,
          prevProps: {},
          nextProps: this.props,
          instance: markerClusterer$1
        });
        this.setState(function setClusterer() {
          return {
            markerClusterer: markerClusterer$1
          };
        }, this.setClustererCallback);
      }
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      if (this.state.markerClusterer) {
        unregisterEvents(this.registeredEvents);
        this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
          updaterMap: updaterMap$4,
          eventMap: eventMap$4,
          prevProps: prevProps,
          nextProps: this.props,
          instance: this.state.markerClusterer
        });
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.markerClusterer !== null) {
        if (this.props.onUnmount) {
          this.props.onUnmount(this.state.markerClusterer);
        }

        unregisterEvents(this.registeredEvents); // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
        // @ts-ignore

        this.state.markerClusterer.setMap(null);
      }
    };

    _proto.render = function render() {
      return this.state.markerClusterer !== null ? this.props.children(this.state.markerClusterer) : null;
    };

    return ClustererComponent;
  }(React.PureComponent);
  ClustererComponent.contextType = MapContext;

  var eventMap$5 = {
    onCloseClick: 'closeclick',
    onContentChanged: 'content_changed',
    onDomReady: 'domready',
    onPositionChanged: 'position_changed',
    onZindexChanged: 'zindex_changed'
  };
  var updaterMap$5 = {
    options: function options(instance, _options) {
      instance.setOptions(_options);
    },
    position: function position(instance, _position) {
      if (_position instanceof google.maps.LatLng) {
        instance.setPosition(_position);
      } else {
        instance.setPosition(new google.maps.LatLng(_position.lat, _position.lng));
      }
    },
    visible: function visible(instance, _visible) {
      instance.setVisible(_visible);
    },
    zIndex: function zIndex(instance, _zIndex) {
      instance.setZIndex(_zIndex);
    }
  };
  var InfoBoxComponent =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(InfoBoxComponent, _React$PureComponent);

    function InfoBoxComponent() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.registeredEvents = [];
      _this.containerElement = null;
      _this.state = {
        infoBox: null
      };

      _this.open = function (infoBox, anchor) {
        if (anchor) {
          infoBox.open(_this.context, anchor);
        } else if (infoBox.getPosition()) {
          infoBox.open(_this.context);
        } else {
            invariant(false, 'You must provide either an anchor or a position prop for <InfoBox>.')  ;
        }
      };

      _this.setInfoBoxCallback = function () {
        var _this$props = _this.props,
            anchor = _this$props.anchor,
            onLoad = _this$props.onLoad;
        var infoBox = _this.state.infoBox;

        if (infoBox !== null && _this.containerElement !== null) {
          infoBox.setContent(_this.containerElement);

          _this.open(infoBox, anchor);

          if (onLoad) {
            onLoad(infoBox);
          }
        }
      };

      return _this;
    }

    var _proto = InfoBoxComponent.prototype;

    _proto.componentDidMount = function componentDidMount() {
      var options = this.props.options;

      var _ref = options || {},
          position = _ref.position,
          infoBoxOptions = _objectWithoutPropertiesLoose(_ref, ["position"]);

      var positionLatLng;

      if (position && !(position instanceof google.maps.LatLng)) {
        positionLatLng = new google.maps.LatLng(position.lat, position.lng);
      }

      var infoBox = new infobox.InfoBox(_extends({}, infoBoxOptions, {}, positionLatLng ? {
        position: positionLatLng
      } : {}));
      this.containerElement = document.createElement('div');
      this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
        updaterMap: updaterMap$5,
        eventMap: eventMap$5,
        prevProps: {},
        nextProps: this.props,
        instance: infoBox
      });
      this.setState({
        infoBox: infoBox
      }, this.setInfoBoxCallback);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      var infoBox = this.state.infoBox;

      if (infoBox !== null) {
        unregisterEvents(this.registeredEvents);
        this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
          updaterMap: updaterMap$5,
          eventMap: eventMap$5,
          prevProps: prevProps,
          nextProps: this.props,
          instance: infoBox
        });
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      var onUnmount = this.props.onUnmount;
      var infoBox = this.state.infoBox;

      if (infoBox !== null) {
        if (onUnmount) {
          onUnmount(infoBox);
        }

        unregisterEvents(this.registeredEvents);
        infoBox.close();
      }
    };

    _proto.render = function render() {
      if (!this.containerElement) {
        return null;
      }

      return ReactDOM.createPortal(React.Children.only(this.props.children), this.containerElement);
    };

    return InfoBoxComponent;
  }(React.PureComponent);
  InfoBoxComponent.contextType = MapContext;

  var eventMap$6 = {
    onCloseClick: 'closeclick',
    onContentChanged: 'content_changed',
    onDomReady: 'domready',
    onPositionChanged: 'position_changed',
    onZindexChanged: 'zindex_changed'
  };
  var updaterMap$6 = {
    options: function options(instance, _options) {
      instance.setOptions(_options);
    },
    position: function position(instance, _position) {
      instance.setPosition(_position);
    },
    zIndex: function zIndex(instance, _zIndex) {
      instance.setZIndex(_zIndex);
    }
  };
  var InfoWindow =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(InfoWindow, _React$PureComponent);

    function InfoWindow() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.registeredEvents = [];
      _this.containerElement = null;
      _this.state = {
        infoWindow: null
      };

      _this.open = function (infoWindow, anchor) {
        if (anchor) {
          infoWindow.open(_this.context, anchor);
        } else if (infoWindow.getPosition()) {
          infoWindow.open(_this.context);
        } else {
            invariant(false, "You must provide either an anchor (typically render it inside a <Marker>) or a position props for <InfoWindow>.")  ;
        }
      };

      _this.setInfoWindowCallback = function () {
        if (_this.state.infoWindow !== null && _this.containerElement !== null) {
          _this.state.infoWindow.setContent(_this.containerElement);

          _this.open(_this.state.infoWindow, _this.props.anchor);

          if (_this.props.onLoad) {
            _this.props.onLoad(_this.state.infoWindow);
          }
        }
      };

      return _this;
    }

    var _proto = InfoWindow.prototype;

    _proto.componentDidMount = function componentDidMount() {
      var infoWindow = new google.maps.InfoWindow(_extends({}, this.props.options || {}));
      this.containerElement = document.createElement('div');
      this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
        updaterMap: updaterMap$6,
        eventMap: eventMap$6,
        prevProps: {},
        nextProps: this.props,
        instance: infoWindow
      });
      this.setState(function setInfoWindow() {
        return {
          infoWindow: infoWindow
        };
      }, this.setInfoWindowCallback);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      if (this.state.infoWindow !== null) {
        unregisterEvents(this.registeredEvents);
        this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
          updaterMap: updaterMap$6,
          eventMap: eventMap$6,
          prevProps: prevProps,
          nextProps: this.props,
          instance: this.state.infoWindow
        });
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.infoWindow !== null) {
        unregisterEvents(this.registeredEvents);
        this.state.infoWindow.close();
      }
    };

    _proto.render = function render() {
      return this.containerElement ? ReactDOM.createPortal(React.Children.only(this.props.children), this.containerElement) : React.createElement(React.Fragment, null);
    };

    return InfoWindow;
  }(React.PureComponent);
  InfoWindow.contextType = MapContext;

  var eventMap$7 = {
    onClick: 'click',
    onDblClick: 'dblclick',
    onDrag: 'drag',
    onDragEnd: 'dragend',
    onDragStart: 'dragstart',
    onMouseDown: 'mousedown',
    onMouseMove: 'mousemove',
    onMouseOut: 'mouseout',
    onMouseOver: 'mouseover',
    onMouseUp: 'mouseup',
    onRightClick: 'rightclick'
  };
  var updaterMap$7 = {
    draggable: function draggable(instance, _draggable) {
      instance.setDraggable(_draggable);
    },
    editable: function editable(instance, _editable) {
      instance.setEditable(_editable);
    },
    map: function map(instance, _map) {
      instance.setMap(_map);
    },
    options: function options(instance, _options) {
      instance.setOptions(_options);
    },
    path: function path(instance, _path) {
      instance.setPath(_path);
    },
    visible: function visible(instance, _visible) {
      instance.setVisible(_visible);
    }
  };
  var Polyline =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(Polyline, _React$PureComponent);

    function Polyline() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.registeredEvents = [];
      _this.state = {
        polyline: null
      };

      _this.setPolylineCallback = function () {
        if (_this.state.polyline !== null && _this.props.onLoad) {
          _this.props.onLoad(_this.state.polyline);
        }
      };

      return _this;
    }

    var _proto = Polyline.prototype;

    _proto.componentDidMount = function componentDidMount() {
      var polyline = new google.maps.Polyline(_extends({}, this.props.options || {}, {
        map: this.context
      }));
      this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
        updaterMap: updaterMap$7,
        eventMap: eventMap$7,
        prevProps: {},
        nextProps: this.props,
        instance: polyline
      });
      this.setState(function setPolyline() {
        return {
          polyline: polyline
        };
      }, this.setPolylineCallback);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      if (this.state.polyline !== null) {
        unregisterEvents(this.registeredEvents);
        this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
          updaterMap: updaterMap$7,
          eventMap: eventMap$7,
          prevProps: prevProps,
          nextProps: this.props,
          instance: this.state.polyline
        });
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.polyline !== null) {
        if (this.props.onUnmount) {
          this.props.onUnmount(this.state.polyline);
        }

        unregisterEvents(this.registeredEvents);
        this.state.polyline.setMap(null);
      }
    };

    _proto.render = function render() {
      return React.createElement(React.Fragment, null);
    };

    return Polyline;
  }(React.PureComponent);
  Polyline.contextType = MapContext;

  var eventMap$8 = {
    onClick: 'click',
    onDblClick: 'dblclick',
    onDrag: 'drag',
    onDragEnd: 'dragend',
    onDragStart: 'dragstart',
    onMouseDown: 'mousedown',
    onMouseMove: 'mousemove',
    onMouseOut: 'mouseout',
    onMouseOver: 'mouseover',
    onMouseUp: 'mouseup',
    onRightClick: 'rightclick'
  };
  var updaterMap$8 = {
    draggable: function draggable(instance, _draggable) {
      instance.setDraggable(_draggable);
    },
    editable: function editable(instance, _editable) {
      instance.setEditable(_editable);
    },
    map: function map(instance, _map) {
      instance.setMap(_map);
    },
    options: function options(instance, _options) {
      instance.setOptions(_options);
    },
    path: function path(instance, _path) {
      instance.setPath(_path);
    },
    paths: function paths(instance, _paths) {
      instance.setPaths(_paths);
    },
    visible: function visible(instance, _visible) {
      instance.setVisible(_visible);
    }
  };
  var Polygon =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(Polygon, _React$PureComponent);

    function Polygon() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.registeredEvents = [];
      _this.state = {
        polygon: null
      };

      _this.setPolygonCallback = function () {
        if (_this.state.polygon !== null && _this.props.onLoad) {
          _this.props.onLoad(_this.state.polygon);
        }
      };

      return _this;
    }

    var _proto = Polygon.prototype;

    _proto.componentDidMount = function componentDidMount() {
      var polygon = new google.maps.Polygon(_extends({}, this.props.options || {}, {
        map: this.context
      }));
      this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
        updaterMap: updaterMap$8,
        eventMap: eventMap$8,
        prevProps: {},
        nextProps: this.props,
        instance: polygon
      });
      this.setState(function setPolygon() {
        return {
          polygon: polygon
        };
      }, this.setPolygonCallback);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      if (this.state.polygon !== null) {
        unregisterEvents(this.registeredEvents);
        this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
          updaterMap: updaterMap$8,
          eventMap: eventMap$8,
          prevProps: prevProps,
          nextProps: this.props,
          instance: this.state.polygon
        });
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.polygon !== null) {
        if (this.props.onUnmount) {
          this.props.onUnmount(this.state.polygon);
        }

        unregisterEvents(this.registeredEvents);
        this.state.polygon && this.state.polygon.setMap(null);
      }
    };

    _proto.render = function render() {
      return null;
    };

    return Polygon;
  }(React.PureComponent);
  Polygon.contextType = MapContext;

  var eventMap$9 = {
    onBoundsChanged: 'bounds_changed',
    onClick: 'click',
    onDblClick: 'dblclick',
    onDrag: 'drag',
    onDragEnd: 'dragend',
    onDragStart: 'dragstart',
    onMouseDown: 'mousedown',
    onMouseMove: 'mousemove',
    onMouseOut: 'mouseout',
    onMouseOver: 'mouseover',
    onMouseUp: 'mouseup',
    onRightClick: 'rightclick'
  };
  var updaterMap$9 = {
    bounds: function bounds(instance, _bounds) {
      instance.setBounds(_bounds);
    },
    draggable: function draggable(instance, _draggable) {
      instance.setDraggable(_draggable);
    },
    editable: function editable(instance, _editable) {
      instance.setEditable(_editable);
    },
    map: function map(instance, _map) {
      instance.setMap(_map);
    },
    options: function options(instance, _options) {
      instance.setOptions(_options);
    },
    visible: function visible(instance, _visible) {
      instance.setVisible(_visible);
    }
  };
  var Rectangle =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(Rectangle, _React$PureComponent);

    function Rectangle() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.registeredEvents = [];
      _this.state = {
        rectangle: null
      };

      _this.setRectangleCallback = function () {
        if (_this.state.rectangle !== null && _this.props.onLoad) {
          _this.props.onLoad(_this.state.rectangle);
        }
      };

      return _this;
    }

    var _proto = Rectangle.prototype;

    _proto.componentDidMount = function componentDidMount() {
      var rectangle = new google.maps.Rectangle(_extends({}, this.props.options || {}, {
        map: this.context
      }));
      this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
        updaterMap: updaterMap$9,
        eventMap: eventMap$9,
        prevProps: {},
        nextProps: this.props,
        instance: rectangle
      });
      this.setState(function setRectangle() {
        return {
          rectangle: rectangle
        };
      }, this.setRectangleCallback);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      if (this.state.rectangle !== null) {
        unregisterEvents(this.registeredEvents);
        this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
          updaterMap: updaterMap$9,
          eventMap: eventMap$9,
          prevProps: prevProps,
          nextProps: this.props,
          instance: this.state.rectangle
        });
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.rectangle !== null) {
        if (this.props.onUnmount) {
          this.props.onUnmount(this.state.rectangle);
        }

        unregisterEvents(this.registeredEvents);
        this.state.rectangle.setMap(null);
      }
    };

    _proto.render = function render() {
      return React.createElement(React.Fragment, null);
    };

    return Rectangle;
  }(React.PureComponent);
  Rectangle.contextType = MapContext;

  var eventMap$a = {
    onCenterChanged: 'center_changed',
    onClick: 'click',
    onDblClick: 'dblclick',
    onDrag: 'drag',
    onDragEnd: 'dragend',
    onDragStart: 'dragstart',
    onMouseDown: 'mousedown',
    onMouseMove: 'mousemove',
    onMouseOut: 'mouseout',
    onMouseOver: 'mouseover',
    onMouseUp: 'mouseup',
    onRadiusChanged: 'radius_changed',
    onRightClick: 'rightclick'
  };
  var updaterMap$a = {
    center: function center(instance, _center) {
      instance.setCenter(_center);
    },
    draggable: function draggable(instance, _draggable) {
      instance.setDraggable(_draggable);
    },
    editable: function editable(instance, _editable) {
      instance.setEditable(_editable);
    },
    map: function map(instance, _map) {
      instance.setMap(_map);
    },
    options: function options(instance, _options) {
      instance.setOptions(_options);
    },
    radius: function radius(instance, _radius) {
      instance.setRadius(_radius);
    },
    visible: function visible(instance, _visible) {
      instance.setVisible(_visible);
    }
  };
  var Circle =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(Circle, _React$PureComponent);

    function Circle() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.registeredEvents = [];
      _this.state = {
        circle: null
      };

      _this.setCircleCallback = function () {
        if (_this.state.circle !== null && _this.props.onLoad) {
          _this.props.onLoad(_this.state.circle);
        }
      };

      return _this;
    }

    var _proto = Circle.prototype;

    _proto.componentDidMount = function componentDidMount() {
      var circle = new google.maps.Circle(_extends({}, this.props.options || {}, {
        map: this.context
      }));
      this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
        updaterMap: updaterMap$a,
        eventMap: eventMap$a,
        prevProps: {},
        nextProps: this.props,
        instance: circle
      });
      this.setState(function setCircle() {
        return {
          circle: circle
        };
      }, this.setCircleCallback);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      if (this.state.circle !== null) {
        unregisterEvents(this.registeredEvents);
        this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
          updaterMap: updaterMap$a,
          eventMap: eventMap$a,
          prevProps: prevProps,
          nextProps: this.props,
          instance: this.state.circle
        });
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.circle !== null) {
        if (this.props.onUnmount) {
          this.props.onUnmount(this.state.circle);
        }

        unregisterEvents(this.registeredEvents);
        this.state.circle && this.state.circle.setMap(null);
      }
    };

    _proto.render = function render() {
      return React.createElement(React.Fragment, null);
    };

    return Circle;
  }(React.PureComponent);
  Circle.contextType = MapContext;

  var eventMap$b = {
    onAddFeature: 'addfeature',
    onClick: 'click',
    onDblClick: 'dblclick',
    onMouseDown: 'mousedown',
    onMouseOut: 'mouseout',
    onMouseOver: 'mouseover',
    onMouseUp: 'mouseup',
    onRemoveFeature: 'removefeature',
    onRemoveProperty: 'removeproperty',
    onRightClick: 'rightclick',
    onSetGeometry: 'setgeometry',
    onSetProperty: 'setproperty'
  };
  var updaterMap$b = {
    add: function add(instance, features) {
      instance.add(features);
    },
    addgeojson: function addgeojson(instance, geojson, options) {
      instance.addGeoJson(geojson, options);
    },
    contains: function contains(instance, feature) {
      instance.contains(feature);
    },
    foreach: function foreach(instance, callback) {
      instance.forEach(callback);
    },
    loadgeojson: function loadgeojson(instance, url, options, callback) {
      instance.loadGeoJson(url, options, callback);
    },
    overridestyle: function overridestyle(instance, feature, style) {
      instance.overrideStyle(feature, style);
    },
    remove: function remove(instance, feature) {
      instance.remove(feature);
    },
    revertstyle: function revertstyle(instance, feature) {
      instance.revertStyle(feature);
    },
    controlposition: function controlposition(instance, controlPosition) {
      instance.setControlPosition(controlPosition);
    },
    controls: function controls(instance, _controls) {
      instance.setControls(_controls);
    },
    drawingmode: function drawingmode(instance, mode) {
      instance.setDrawingMode(mode);
    },
    map: function map(instance, _map) {
      instance.setMap(_map);
    },
    style: function style(instance, _style) {
      instance.setStyle(_style);
    },
    togeojson: function togeojson(instance, callback) {
      instance.toGeoJson(callback);
    }
  };
  var Data =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(Data, _React$PureComponent);

    function Data() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.registeredEvents = [];
      _this.state = {
        data: null
      };

      _this.setDataCallback = function () {
        if (_this.state.data !== null && _this.props.onLoad) {
          _this.props.onLoad(_this.state.data);
        }
      };

      return _this;
    }

    var _proto = Data.prototype;

    _proto.componentDidMount = function componentDidMount() {
      var data = new google.maps.Data(_extends({}, this.props.options || {}, {
        map: this.context
      }));
      this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
        updaterMap: updaterMap$b,
        eventMap: eventMap$b,
        prevProps: {},
        nextProps: this.props,
        instance: data
      });
      this.setState(function setData() {
        return {
          data: data
        };
      }, this.setDataCallback);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      if (this.state.data !== null) {
        unregisterEvents(this.registeredEvents);
        this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
          updaterMap: updaterMap$b,
          eventMap: eventMap$b,
          prevProps: prevProps,
          nextProps: this.props,
          instance: this.state.data
        });
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.data !== null) {
        if (this.props.onUnmount) {
          this.props.onUnmount(this.state.data);
        }

        unregisterEvents(this.registeredEvents);

        if (this.state.data) {
          this.state.data.setMap(null);
        }
      }
    };

    _proto.render = function render() {
      return null;
    };

    return Data;
  }(React.PureComponent);
  Data.contextType = MapContext;

  var eventMap$c = {
    onClick: 'click',
    onDefaultViewportChanged: 'defaultviewport_changed',
    onStatusChanged: 'status_changed'
  };
  var updaterMap$c = {
    options: function options(instance, _options) {
      instance.setOptions(_options);
    },
    url: function url(instance, _url) {
      instance.setUrl(_url);
    },
    zIndex: function zIndex(instance, _zIndex) {
      instance.setZIndex(_zIndex);
    }
  };
  var KmlLayer =
  /*#__PURE__*/
  function (_PureComponent) {
    _inheritsLoose(KmlLayer, _PureComponent);

    function KmlLayer() {
      var _this;

      _this = _PureComponent.apply(this, arguments) || this;
      _this.registeredEvents = [];
      _this.state = {
        kmlLayer: null
      };

      _this.setKmlLayerCallback = function () {
        if (_this.state.kmlLayer !== null && _this.props.onLoad) {
          _this.props.onLoad(_this.state.kmlLayer);
        }
      };

      return _this;
    }

    var _proto = KmlLayer.prototype;

    _proto.componentDidMount = function componentDidMount() {
      var kmlLayer = new google.maps.KmlLayer(_extends({}, this.props.options, {
        map: this.context
      }));
      this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
        updaterMap: updaterMap$c,
        eventMap: eventMap$c,
        prevProps: {},
        nextProps: this.props,
        instance: kmlLayer
      });
      this.setState(function setLmlLayer() {
        return {
          kmlLayer: kmlLayer
        };
      }, this.setKmlLayerCallback);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      if (this.state.kmlLayer !== null) {
        unregisterEvents(this.registeredEvents);
        this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
          updaterMap: updaterMap$c,
          eventMap: eventMap$c,
          prevProps: prevProps,
          nextProps: this.props,
          instance: this.state.kmlLayer
        });
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.kmlLayer !== null) {
        if (this.props.onUnmount) {
          this.props.onUnmount(this.state.kmlLayer);
        }

        unregisterEvents(this.registeredEvents);
        this.state.kmlLayer.setMap(null);
      }
    };

    _proto.render = function render() {
      return null;
    };

    return KmlLayer;
  }(React.PureComponent);
  KmlLayer.contextType = MapContext;

  /* eslint-disable filenames/match-regex */
  function getOffsetOverride(containerElement, getPixelPositionOffset) {
    return typeof getPixelPositionOffset === 'function' ? getPixelPositionOffset(containerElement.offsetWidth, containerElement.offsetHeight) : {};
  } // eslint-disable-next-line @typescript-eslint/no-explicit-any

  var createLatLng = function createLatLng(inst, Type) {
    return new Type(inst.lat, inst.lng);
  }; // eslint-disable-next-line @typescript-eslint/no-explicit-any


  var createLatLngBounds = function createLatLngBounds(inst, Type) {
    return new Type(new google.maps.LatLng(inst.ne.lat, inst.ne.lng), new google.maps.LatLng(inst.sw.lat, inst.sw.lng));
  }; // eslint-disable-next-line @typescript-eslint/no-explicit-any


  var ensureOfType = function ensureOfType(inst, type, factory) {
    return inst instanceof type ? inst : factory(inst, type);
  };

  var getLayoutStylesByBounds = function getLayoutStylesByBounds(mapCanvasProjection, offset, bounds) {
    var ne = mapCanvasProjection.fromLatLngToDivPixel(bounds.getNorthEast());
    var sw = mapCanvasProjection.fromLatLngToDivPixel(bounds.getSouthWest());

    if (ne && sw) {
      return {
        left: sw.x + offset.x + "px",
        top: ne.y + offset.y + "px",
        width: ne.x - sw.x - offset.x + "px",
        height: sw.y - ne.y - offset.y + "px"
      };
    }

    return {
      left: '-9999px',
      top: '-9999px'
    };
  };

  var getLayoutStylesByPosition = function getLayoutStylesByPosition(mapCanvasProjection, offset, position) {
    var point = mapCanvasProjection.fromLatLngToDivPixel(position);

    if (point) {
      var x = point.x,
          y = point.y;
      return {
        left: x + offset.x + "px",
        top: y + offset.y + "px"
      };
    }

    return {
      left: '-9999px',
      top: '-9999px'
    };
  };

  var getLayoutStyles = function getLayoutStyles(mapCanvasProjection, offset, bounds, position) {
    return bounds !== undefined ? getLayoutStylesByBounds(mapCanvasProjection, offset, ensureOfType(bounds, google.maps.LatLngBounds, createLatLngBounds)) : getLayoutStylesByPosition(mapCanvasProjection, offset, ensureOfType(position, google.maps.LatLng, createLatLng));
  };

  var ContentMountHandler =
  /*#__PURE__*/
  function (_React$Component) {
    _inheritsLoose(ContentMountHandler, _React$Component);

    function ContentMountHandler() {
      return _React$Component.apply(this, arguments) || this;
    }

    var _proto = ContentMountHandler.prototype;

    _proto.componentDidMount = function componentDidMount() {
      if (this.props.onLoad) {
        this.props.onLoad();
      }
    };

    _proto.render = function render() {
      return this.props.children;
    };

    return ContentMountHandler;
  }(React.Component);

  var OverlayView =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(OverlayView, _React$PureComponent);

    function OverlayView() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.state = {
        overlayView: null
      };
      _this.containerElement = null;

      _this.setOverlayViewCallback = function () {
        if (_this.state.overlayView !== null && _this.props.onLoad) {
          _this.props.onLoad(_this.state.overlayView);
        }

        _this.onPositionElement();
      };

      _this.onAdd = function () {
        _this.containerElement = document.createElement('div');
        _this.containerElement.style.position = 'absolute';
      };

      _this.onPositionElement = function () {
        if (_this.state.overlayView !== null && _this.containerElement !== null) {
          var mapCanvasProjection = _this.state.overlayView.getProjection();

          var offset = _extends({
            x: 0,
            y: 0
          }, getOffsetOverride(_this.containerElement, _this.props.getPixelPositionOffset));

          var layoutStyles = getLayoutStyles(mapCanvasProjection, offset, _this.props.bounds, _this.props.position);
          Object.assign(_this.containerElement.style, layoutStyles);
        }
      };

      _this.draw = function () {
        !!!_this.props.mapPaneName ?  invariant(false, "OverlayView requires props.mapPaneName but got %s", _this.props.mapPaneName)  : void 0;
        var overlayView = _this.state.overlayView;

        if (overlayView === null) {
          return;
        } // https://developers.google.com/maps/documentation/javascript/3.exp/reference#MapPanes
        // eslint-disable-next-line @typescript-eslint/no-explicit-any


        var mapPanes = overlayView.getPanes();

        if (!mapPanes) {
          return;
        }

        if (_this.containerElement) {
          mapPanes[_this.props.mapPaneName].appendChild(_this.containerElement);
        }

        _this.onPositionElement();

        _this.forceUpdate();
      };

      _this.onRemove = function () {
        if (_this.containerElement !== null && _this.containerElement.parentNode) {
          _this.containerElement.parentNode.removeChild(_this.containerElement);

          delete _this.containerElement;
        }
      };

      return _this;
    }

    var _proto = OverlayView.prototype;

    _proto.componentDidMount = function componentDidMount() {
      var overlayView = new google.maps.OverlayView(); // You must implement three methods: onAdd(), draw(), and onRemove().

      overlayView.onAdd = this.onAdd;
      overlayView.draw = this.draw;
      overlayView.onRemove = this.onRemove;
      overlayView.setMap(this.context); // You must call setMap() with a valid Map object to trigger the call to
      // the onAdd() method and setMap(null) in order to trigger the onRemove() method.

      this.setState(function setOverlayView() {
        return {
          overlayView: overlayView
        };
      });
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      var _this2 = this;

      if (prevProps.position !== this.props.position || prevProps.bounds !== this.props.bounds) {
        setTimeout(function () {
          _this2.state.overlayView !== null && _this2.state.overlayView.draw();
        }, 0);
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.overlayView !== null) {
        if (this.props.onUnmount) {
          this.props.onUnmount(this.state.overlayView);
        }

        this.state.overlayView.setMap(null);
      }
    };

    _proto.render = function render() {
      return this.containerElement !== null ? ReactDOM.createPortal(React.createElement(ContentMountHandler, {
        onLoad: this.setOverlayViewCallback
      }, React.Children.only(this.props.children)), this.containerElement) : React.createElement(React.Fragment, null);
    };

    return OverlayView;
  }(React.PureComponent);
  OverlayView.FLOAT_PANE = "floatPane";
  OverlayView.MAP_PANE = "mapPane";
  OverlayView.MARKER_LAYER = "markerLayer";
  OverlayView.OVERLAY_LAYER = "overlayLayer";
  OverlayView.OVERLAY_MOUSE_TARGET = "overlayMouseTarget";
  OverlayView.contextType = MapContext;

  function noop() {}

  var eventMap$d = {
    onDblClick: 'dblclick',
    onClick: 'click'
  };
  var updaterMap$d = {
    opacity: function opacity(instance, _opacity) {
      instance.setOpacity(_opacity);
    }
  };
  var GroundOverlay =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(GroundOverlay, _React$PureComponent);

    function GroundOverlay() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.registeredEvents = [];
      _this.state = {
        groundOverlay: null
      };

      _this.setGroundOverlayCallback = function () {
        if (_this.state.groundOverlay !== null && _this.props.onLoad) {
          _this.props.onLoad(_this.state.groundOverlay);
        }
      };

      return _this;
    }

    var _proto = GroundOverlay.prototype;

    _proto.componentDidMount = function componentDidMount() {
      !(!!this.props.url || !!this.props.bounds) ?  invariant(false, "For GroundOverlay, url and bounds are passed in to constructor and are immutable after instantiated. This is the behavior of Google Maps JavaScript API v3 ( See https://developers.google.com/maps/documentation/javascript/reference#GroundOverlay) Hence, use the corresponding two props provided by `react-google-maps-api`, url and bounds. In some cases, you'll need the GroundOverlay component to reflect the changes of url and bounds. You can leverage the React's key property to remount the component. Typically, just `key={url}` would serve your need. See https://github.com/tomchentw/react-google-maps/issues/655")  : void 0;
      var groundOverlay = new google.maps.GroundOverlay(this.props.url, this.props.bounds, _extends({}, this.props.options, {
        map: this.context
      }));
      this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
        updaterMap: updaterMap$d,
        eventMap: eventMap$d,
        prevProps: {},
        nextProps: this.props,
        instance: groundOverlay
      });
      this.setState(function setGroundOverlay() {
        return {
          groundOverlay: groundOverlay
        };
      }, this.setGroundOverlayCallback);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      if (this.state.groundOverlay !== null) {
        unregisterEvents(this.registeredEvents);
        this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
          updaterMap: updaterMap$d,
          eventMap: eventMap$d,
          prevProps: prevProps,
          nextProps: this.props,
          instance: this.state.groundOverlay
        });
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.groundOverlay) {
        if (this.props.onUnmount) {
          this.props.onUnmount(this.state.groundOverlay);
        }

        this.state.groundOverlay.setMap(null);
      }
    };

    _proto.render = function render() {
      return null;
    };

    return GroundOverlay;
  }(React.PureComponent);
  GroundOverlay.defaultProps = {
    onLoad: noop
  };
  GroundOverlay.contextType = MapContext;

  var eventMap$e = {};
  var updaterMap$e = {
    data: function data(instance, _data) {
      instance.setData(_data);
    },
    map: function map(instance, _map) {
      instance.setMap(_map);
    },
    options: function options(instance, _options) {
      instance.setOptions(_options);
    }
  };
  var HeatmapLayer =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(HeatmapLayer, _React$PureComponent);

    function HeatmapLayer() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.registeredEvents = [];
      _this.state = {
        heatmapLayer: null
      };

      _this.setHeatmapLayerCallback = function () {
        if (_this.state.heatmapLayer !== null && _this.props.onLoad) {
          _this.props.onLoad(_this.state.heatmapLayer);
        }
      };

      return _this;
    }

    var _proto = HeatmapLayer.prototype;

    _proto.componentDidMount = function componentDidMount() {
      !!!google.maps.visualization ?  invariant(false, 'Did you include prop libraries={["visualization"]} to <LoadScript />? %s', google.maps.visualization)  : void 0;
      !!!this.props.data ?  invariant(false, 'data property is required in HeatmapLayer %s', this.props.data)  : void 0;
      var heatmapLayer = new google.maps.visualization.HeatmapLayer(_extends({
        data: this.props.data
      }, this.props.options || {}, {
        map: this.context
      }));
      this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
        updaterMap: updaterMap$e,
        eventMap: eventMap$e,
        prevProps: {},
        nextProps: this.props,
        instance: heatmapLayer
      });
      this.setState(function setHeatmapLayer() {
        return {
          heatmapLayer: heatmapLayer
        };
      }, this.setHeatmapLayerCallback);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      unregisterEvents(this.registeredEvents);
      this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
        updaterMap: updaterMap$e,
        eventMap: eventMap$e,
        prevProps: prevProps,
        nextProps: this.props,
        instance: this.state.heatmapLayer
      });
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.heatmapLayer !== null) {
        if (this.props.onUnmount) {
          this.props.onUnmount(this.state.heatmapLayer);
        }

        unregisterEvents(this.registeredEvents);
        this.state.heatmapLayer.setMap(null);
      }
    };

    _proto.render = function render() {
      return null;
    };

    return HeatmapLayer;
  }(React.PureComponent);
  HeatmapLayer.contextType = MapContext;

  var eventMap$f = {
    onCloseClick: 'closeclick',
    onPanoChanged: 'pano_changed',
    onPositionChanged: 'position_changed',
    onPovChanged: 'pov_changed',
    onResize: 'resize',
    onStatusChanged: 'status_changed',
    onVisibleChanged: 'visible_changed',
    onZoomChanged: 'zoom_changed'
  };
  var updaterMap$f = {
    register: function register(instance, provider, options) {
      instance.registerPanoProvider(provider, options);
    },
    links: function links(instance, _links) {
      instance.setLinks(_links);
    },
    motionTracking: function motionTracking(instance, _motionTracking) {
      instance.setMotionTracking(_motionTracking);
    },
    options: function options(instance, _options) {
      instance.setOptions(_options);
    },
    pano: function pano(instance, _pano) {
      instance.setPano(_pano);
    },
    position: function position(instance, _position) {
      instance.setPosition(_position);
    },
    pov: function pov(instance, _pov) {
      instance.setPov(_pov);
    },
    visible: function visible(instance, _visible) {
      instance.setVisible(_visible);
    },
    zoom: function zoom(instance, _zoom) {
      instance.setZoom(_zoom);
    }
  };
  var StreetViewPanorama =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(StreetViewPanorama, _React$PureComponent);

    function StreetViewPanorama() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.registeredEvents = [];
      _this.state = {
        streetViewPanorama: null
      };

      _this.setStreetViewPanoramaCallback = function () {
        if (_this.state.streetViewPanorama !== null && _this.props.onLoad) {
          _this.props.onLoad(_this.state.streetViewPanorama);
        }
      };

      return _this;
    }

    var _proto = StreetViewPanorama.prototype;

    _proto.componentDidMount = function componentDidMount() {
      var streetViewPanorama = this.context.getStreetView();
      this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
        updaterMap: updaterMap$f,
        eventMap: eventMap$f,
        prevProps: {},
        nextProps: this.props,
        instance: streetViewPanorama
      });
      this.setState(function setStreetViewPanorama() {
        return {
          streetViewPanorama: streetViewPanorama
        };
      }, this.setStreetViewPanoramaCallback);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      if (this.state.streetViewPanorama !== null) {
        unregisterEvents(this.registeredEvents);
        this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
          updaterMap: updaterMap$f,
          eventMap: eventMap$f,
          prevProps: prevProps,
          nextProps: this.props,
          instance: this.state.streetViewPanorama
        });
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.streetViewPanorama !== null) {
        if (this.props.onUnmount) {
          this.props.onUnmount(this.state.streetViewPanorama);
        }

        unregisterEvents(this.registeredEvents);
        this.state.streetViewPanorama.setVisible(false);
      }
    };

    _proto.render = function render() {
      return null;
    };

    return StreetViewPanorama;
  }(React.PureComponent);
  StreetViewPanorama.contextType = MapContext;

  var StreetViewService =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(StreetViewService, _React$PureComponent);

    function StreetViewService() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.state = {
        streetViewService: null
      };

      _this.setStreetViewServiceCallback = function () {
        if (_this.state.streetViewService !== null && _this.props.onLoad) {
          _this.props.onLoad(_this.state.streetViewService);
        }
      };

      return _this;
    }

    var _proto = StreetViewService.prototype;

    _proto.componentDidMount = function componentDidMount() {
      var streetViewService = new google.maps.StreetViewService();
      this.setState(function setStreetViewService() {
        return {
          streetViewService: streetViewService
        };
      });
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.streetViewService !== null) {
        if (this.props.onUnmount) {
          this.props.onUnmount(this.state.streetViewService);
        }
      }
    };

    _proto.render = function render() {
      return null;
    };

    return StreetViewService;
  }(React.PureComponent);
  StreetViewService.contextType = MapContext;

  var DirectionsService =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(DirectionsService, _React$PureComponent);

    function DirectionsService() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.state = {
        directionsService: null
      };

      _this.setDirectionsServiceCallback = function () {
        if (_this.state.directionsService !== null && _this.props.onLoad) {
          _this.props.onLoad(_this.state.directionsService);
        }
      };

      return _this;
    }

    var _proto = DirectionsService.prototype;

    _proto.componentDidMount = function componentDidMount() {
      !!!this.props.options ?  invariant(false, 'DirectionsService expected options object as parameter, but got %s', this.props.options)  : void 0;
      var directionsService = new google.maps.DirectionsService();
      this.setState(function setDirectionsService() {
        return {
          directionsService: directionsService
        };
      }, this.setDirectionsServiceCallback);
    };

    _proto.componentDidUpdate = function componentDidUpdate() {
      if (this.state.directionsService !== null) {
        this.state.directionsService.route(this.props.options, this.props.callback);
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.directionsService !== null) {
        if (this.props.onUnmount) {
          this.props.onUnmount(this.state.directionsService);
        }
      }
    };

    _proto.render = function render() {
      return React.createElement(React.Fragment, null);
    };

    return DirectionsService;
  }(React.PureComponent);

  var eventMap$g = {
    onDirectionsChanged: 'directions_changed'
  };
  var updaterMap$g = {
    directions: function directions(instance, _directions) {
      instance.setDirections(_directions);
    },
    map: function map(instance, _map) {
      instance.setMap(_map);
    },
    options: function options(instance, _options) {
      instance.setOptions(_options);
    },
    panel: function panel(instance, _panel) {
      instance.setPanel(_panel);
    },
    routeIndex: function routeIndex(instance, _routeIndex) {
      instance.setRouteIndex(_routeIndex);
    }
  };
  var DirectionsRenderer =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(DirectionsRenderer, _React$PureComponent);

    function DirectionsRenderer() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.registeredEvents = [];
      _this.state = {
        directionsRenderer: null
      };

      _this.setDirectionsRendererCallback = function () {
        if (_this.state.directionsRenderer !== null) {
          _this.state.directionsRenderer.setMap(_this.context);

          if (_this.props.onLoad) {
            _this.props.onLoad(_this.state.directionsRenderer);
          }
        }
      };

      return _this;
    }

    var _proto = DirectionsRenderer.prototype;

    _proto.componentDidMount = function componentDidMount() {
      var directionsRenderer = new google.maps.DirectionsRenderer(this.props.options);
      this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
        updaterMap: updaterMap$g,
        eventMap: eventMap$g,
        prevProps: {},
        nextProps: this.props,
        instance: directionsRenderer
      });
      this.setState(function setDirectionsRenderer() {
        return {
          directionsRenderer: directionsRenderer
        };
      }, this.setDirectionsRendererCallback);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      if (this.state.directionsRenderer !== null) {
        unregisterEvents(this.registeredEvents);
        this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
          updaterMap: updaterMap$g,
          eventMap: eventMap$g,
          prevProps: prevProps,
          nextProps: this.props,
          instance: this.state.directionsRenderer
        });
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.directionsRenderer !== null) {
        if (this.props.onUnmount) {
          this.props.onUnmount(this.state.directionsRenderer);
        }

        unregisterEvents(this.registeredEvents);

        if (this.state.directionsRenderer) {
          this.state.directionsRenderer.setMap(null);
        }
      }
    };

    _proto.render = function render() {
      return React.createElement(React.Fragment, null);
    };

    return DirectionsRenderer;
  }(React.PureComponent);
  DirectionsRenderer.contextType = MapContext;

  var DistanceMatrixService =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(DistanceMatrixService, _React$PureComponent);

    function DistanceMatrixService() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.state = {
        distanceMatrixService: null
      };

      _this.setDistanceMatrixServiceCallback = function () {
        if (_this.state.distanceMatrixService !== null && _this.props.onLoad) {
          _this.props.onLoad(_this.state.distanceMatrixService);
        }
      };

      return _this;
    }

    var _proto = DistanceMatrixService.prototype;

    _proto.componentDidMount = function componentDidMount() {
      !!!this.props.options ?  invariant(false, 'DistanceMatrixService expected options object as parameter, but go %s', this.props.options)  : void 0;
      var distanceMatrixService = new google.maps.DistanceMatrixService();
      this.setState(function setDistanceMatrixService() {
        return {
          distanceMatrixService: distanceMatrixService
        };
      }, this.setDistanceMatrixServiceCallback);
    };

    _proto.componentDidUpdate = function componentDidUpdate() {
      if (this.state.distanceMatrixService !== null) {
        this.state.distanceMatrixService.getDistanceMatrix(this.props.options, this.props.callback);
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.distanceMatrixService !== null) {
        if (this.props.onUnmount) {
          this.props.onUnmount(this.state.distanceMatrixService);
        }
      }
    };

    _proto.render = function render() {
      return React.createElement(React.Fragment, null);
    };

    return DistanceMatrixService;
  }(React.PureComponent);

  var eventMap$h = {
    onPlacesChanged: 'places_changed'
  };
  var updaterMap$h = {
    bounds: function bounds(instance, _bounds) {
      instance.setBounds(_bounds);
    }
  };

  var StandaloneSearchBox =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(StandaloneSearchBox, _React$PureComponent);

    function StandaloneSearchBox() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.registeredEvents = [];
      _this.containerElement = React.createRef();
      _this.state = {
        searchBox: null
      };

      _this.setSearchBoxCallback = function () {
        if (_this.state.searchBox !== null && _this.props.onLoad) {
          _this.props.onLoad(_this.state.searchBox);
        }
      };

      return _this;
    }

    var _proto = StandaloneSearchBox.prototype;

    _proto.componentDidMount = function componentDidMount() {
      !!!google.maps.places ?  invariant(false, 'You need to provide libraries={["places"]} prop to <LoadScript /> component %s', google.maps.places)  : void 0;

      if (this.containerElement !== null && this.containerElement.current !== null) {
        var input = this.containerElement.current.querySelector('input');

        if (input !== null) {
          var searchBox = new google.maps.places.SearchBox(input, this.props.options);
          this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
            updaterMap: updaterMap$h,
            eventMap: eventMap$h,
            prevProps: {},
            nextProps: this.props,
            instance: searchBox
          });
          this.setState(function setSearchBox() {
            return {
              searchBox: searchBox
            };
          }, this.setSearchBoxCallback);
        }
      }
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      if (this.state.searchBox !== null) {
        unregisterEvents(this.registeredEvents);
        this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
          updaterMap: updaterMap$h,
          eventMap: eventMap$h,
          prevProps: prevProps,
          nextProps: this.props,
          instance: this.state.searchBox
        });
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.searchBox !== null) {
        if (this.props.onUnmount) {
          this.props.onUnmount(this.state.searchBox);
        }

        unregisterEvents(this.registeredEvents);
      }
    };

    _proto.render = function render() {
      return React.createElement("div", {
        ref: this.containerElement
      }, React.Children.only(this.props.children));
    };

    return StandaloneSearchBox;
  }(React.PureComponent);

  StandaloneSearchBox.contextType = MapContext;

  var eventMap$i = {
    onPlaceChanged: 'place_changed'
  };
  var updaterMap$i = {
    bounds: function bounds(instance, _bounds) {
      instance.setBounds(_bounds);
    },
    restrictions: function restrictions(instance, _restrictions) {
      instance.setComponentRestrictions(_restrictions);
    },
    fields: function fields(instance, _fields) {
      instance.setFields(_fields);
    },
    options: function options(instance, _options) {
      instance.setOptions(_options);
    },
    types: function types(instance, _types) {
      instance.setTypes(_types);
    }
  };
  var Autocomplete =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inheritsLoose(Autocomplete, _React$PureComponent);

    function Autocomplete() {
      var _this;

      _this = _React$PureComponent.apply(this, arguments) || this;
      _this.registeredEvents = [];
      _this.containerElement = React.createRef();
      _this.state = {
        autocomplete: null
      };

      _this.setAutocompleteCallback = function () {
        if (_this.state.autocomplete !== null && _this.props.onLoad) {
          _this.props.onLoad(_this.state.autocomplete);
        }
      };

      return _this;
    }

    var _proto = Autocomplete.prototype;

    _proto.componentDidMount = function componentDidMount() {
      !!!google.maps.places ?  invariant(false, 'You need to provide libraries={["places"]} prop to <LoadScript /> component %s', google.maps.places)  : void 0; // TODO: why current could be equal null?
      // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
      // @ts-ignore

      var input = this.containerElement.current.querySelector('input');

      if (input) {
        var autocomplete = new google.maps.places.Autocomplete(input, this.props.options);
        this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
          updaterMap: updaterMap$i,
          eventMap: eventMap$i,
          prevProps: {},
          nextProps: this.props,
          instance: autocomplete
        });
        this.setState(function setAutocomplete() {
          return {
            autocomplete: autocomplete
          };
        }, this.setAutocompleteCallback);
      }
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      unregisterEvents(this.registeredEvents);
      this.registeredEvents = applyUpdatersToPropsAndRegisterEvents({
        updaterMap: updaterMap$i,
        eventMap: eventMap$i,
        prevProps: prevProps,
        nextProps: this.props,
        instance: this.state.autocomplete
      });
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      if (this.state.autocomplete !== null) {
        unregisterEvents(this.registeredEvents);
      }
    };

    _proto.render = function render() {
      return React.createElement("div", {
        ref: this.containerElement
      }, React.Children.only(this.props.children));
    };

    return Autocomplete;
  }(React.PureComponent);
  Autocomplete.contextType = MapContext;

  exports.Autocomplete = Autocomplete;
  exports.BicyclingLayer = BicyclingLayer;
  exports.Circle = Circle;
  exports.Data = Data;
  exports.DirectionsRenderer = DirectionsRenderer;
  exports.DirectionsService = DirectionsService;
  exports.DistanceMatrixService = DistanceMatrixService;
  exports.DrawingManager = DrawingManager;
  exports.GoogleMap = GoogleMap;
  exports.GroundOverlay = GroundOverlay;
  exports.HeatmapLayer = HeatmapLayer;
  exports.InfoBox = InfoBoxComponent;
  exports.InfoWindow = InfoWindow;
  exports.KmlLayer = KmlLayer;
  exports.LoadScript = LoadScript;
  exports.LoadScriptNext = LoadScriptNext$1;
  exports.Marker = Marker;
  exports.MarkerClusterer = ClustererComponent;
  exports.OverlayView = OverlayView;
  exports.Polygon = Polygon;
  exports.Polyline = Polyline;
  exports.Rectangle = Rectangle;
  exports.StandaloneSearchBox = StandaloneSearchBox;
  exports.StreetViewPanorama = StreetViewPanorama;
  exports.StreetViewService = StreetViewService;
  exports.TrafficLayer = TrafficLayer;
  exports.TransitLayer = TransitLayer;
  exports.useGoogleMap = useGoogleMap;
  exports.useLoadScript = useLoadScript;

})));
//# sourceMappingURL=reactgooglemapsapi.umd.development.js.map
