# Contributing

All contributions to [react-grid-gallery](https://github.com/benhowell/react-grid-gallery) are very welcome. Feature requests, issue reports and pull requests are greatly appreciated. 

## Issue reports
Unless you're making a clear and simple feature request, please use the template provided. Ignoring the template may cause extra work for maintainers and therefore could delay any action required.

## Feature requests
Please start the title of your issue report with "Feature request:". If any of the template headings are not relevant to the request then please remove them before submitting the request.

## Pull requests
Pull requests of all kinds are welcome. To ensure a smooth integration process, please follow the guidelines below:
* Before making any radical changes, new features or major re-writes, please open an issue request first to discuss the changes with the maintainers.
* Please ensure all examples in the `example` directory work correctly with your new changes.
* If adding new functionality, please include a demo in the `examples` directory.
* Only commit source, example and README files with your pull request. If your changes require extra libs/dependencies then please discuss this first with the maintainers by creating an issue request.
* New functionality requires documentation be added to the README file.
* Please follow the coding style of the project.


Thanks for taking an interest in [react-grid-gallery](https://github.com/benhowell/react-grid-gallery).
