/* eslint "react/no-did-mount-set-state":0, "react/no-did-update-set-state":0 */

'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsPureRenderMixin = require('react-addons-pure-render-mixin');

var ReactHeight = _react2['default'].createClass({
  displayName: 'ReactHeight',

  propTypes: {
    children: _react2['default'].PropTypes.node.isRequired,
    onHeightReady: _react2['default'].PropTypes.func.isRequired,
    hidden: _react2['default'].PropTypes.bool,
    dirty: _react2['default'].PropTypes.bool
  },

  getDefaultProps: function getDefaultProps() {
    return { hidden: false, dirty: true };
  },

  getInitialState: function getInitialState() {
    return {
      height: 0, dirty: this.props.dirty
    };
  },

  componentDidMount: function componentDidMount() {
    var _this = this;

    if (!this.refs.wrapper) {
      return;
    }
    var height = this.refs.wrapper.clientHeight;
    var dirty = false;

    this.setState({ height: height, dirty: dirty }, function () {
      return _this.props.onHeightReady(_this.state.height);
    });
  },

  componentWillReceiveProps: function componentWillReceiveProps(_ref) {
    var children = _ref.children;
    var dirty = _ref.dirty;

    if (children !== this.props.children || dirty) {
      this.setState({ dirty: true });
    }
  },

  shouldComponentUpdate: _reactAddonsPureRenderMixin.shouldComponentUpdate,

  componentDidUpdate: function componentDidUpdate() {
    var _this2 = this;

    if (!this.refs.wrapper) {
      return;
    }
    var height = this.refs.wrapper.clientHeight;
    var dirty = false;

    if (height !== this.state.height) {
      this.setState({ height: height, dirty: dirty }, function () {
        return _this2.props.onHeightReady(_this2.state.height);
      });
    } else {
      this.setState({ dirty: dirty });
    }
  },

  render: function render() {
    var _props = this.props;
    var onHeightReady = _props.onHeightReady;
    var hidden = _props.hidden;
    var children = _props.children;

    var props = _objectWithoutProperties(_props, ['onHeightReady', 'hidden', 'children']);

    var dirty = this.state.dirty;

    if (hidden && !dirty) {
      return null;
    }

    if (hidden) {
      return _react2['default'].createElement(
        'div',
        { style: { height: 0, overflow: 'hidden' } },
        _react2['default'].createElement(
          'div',
          _extends({ ref: 'wrapper' }, props),
          children
        )
      );
    }

    return _react2['default'].createElement(
      'div',
      _extends({ ref: 'wrapper' }, props),
      children
    );
  }
});

exports['default'] = ReactHeight;
module.exports = exports['default'];
//# sourceMappingURL=ReactHeight.js.map