'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _createReactClass = require('create-react-class');

var _createReactClass2 = _interopRequireDefault(_createReactClass);

var _ReactComponentWithPureRenderMixin = require('react/lib/ReactComponentWithPureRenderMixin');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; } /* eslint "react/no-did-mount-set-state":0 */
/* eslint "react/no-did-update-set-state":0 */

var getElementHeight = function getElementHeight(el) {
  return el.clientHeight;
};

var ReactHeight = (0, _createReactClass2.default)({
  propTypes: {
    children: _propTypes2.default.node.isRequired,
    onHeightReady: _propTypes2.default.func.isRequired,
    hidden: _propTypes2.default.bool,
    dirty: _propTypes2.default.bool,
    getElementHeight: _propTypes2.default.func
  },

  getDefaultProps: function getDefaultProps() {
    return {
      hidden: false,
      dirty: true,
      getElementHeight: getElementHeight
    };
  },
  getInitialState: function getInitialState() {
    return {
      height: 0, dirty: this.props.dirty
    };
  },
  componentDidMount: function componentDidMount() {
    var _this = this;

    var height = this.props.getElementHeight(this.wrapper);
    var dirty = false;

    this.setState({ height: height, dirty: dirty }, function () {
      return _this.props.onHeightReady(_this.state.height);
    });
  },
  componentWillReceiveProps: function componentWillReceiveProps(_ref) {
    var children = _ref.children,
        dirty = _ref.dirty;

    if (children !== this.props.children || dirty) {
      this.setState({ dirty: true });
    }
  },


  shouldComponentUpdate: _ReactComponentWithPureRenderMixin.shouldComponentUpdate,

  componentDidUpdate: function componentDidUpdate() {
    var _this2 = this;

    var height = this.props.getElementHeight(this.wrapper);
    var dirty = false;

    if (height === this.state.height) {
      this.setState({ dirty: dirty });
    } else {
      this.setState({ height: height, dirty: dirty }, function () {
        return _this2.props.onHeightReady(_this2.state.height);
      });
    }
  },
  setWrapperRef: function setWrapperRef(el) {
    this.wrapper = el;
  },
  render: function render() {
    var _props = this.props,
        _onHeightReady = _props.onHeightReady,
        _getElementHeight = _props.getElementHeight,
        _dirty = _props.dirty,
        hidden = _props.hidden,
        children = _props.children,
        props = _objectWithoutProperties(_props, ['onHeightReady', 'getElementHeight', 'dirty', 'hidden', 'children']);

    var dirty = this.state.dirty;


    if (hidden && !dirty) {
      return null;
    }

    if (hidden) {
      return _react2.default.createElement(
        'div',
        { style: { height: 0, overflow: 'hidden' } },
        _react2.default.createElement(
          'div',
          _extends({ ref: this.setWrapperRef }, props),
          children
        )
      );
    }

    return _react2.default.createElement(
      'div',
      _extends({ ref: this.setWrapperRef }, props),
      children
    );
  }
});

exports.default = ReactHeight;
//# sourceMappingURL=ReactHeight.js.map