'use strict';

exports.__esModule = true;
exports.historyContext = exports.location = exports.action = undefined;

var _react = require('react');

var action = exports.action = _react.PropTypes.oneOf(['PUSH', 'REPLACE', 'POP']);

var location = exports.location = _react.PropTypes.shape({
  pathname: _react.PropTypes.string.isRequired,
  search: _react.PropTypes.string.isRequired,
  hash: _react.PropTypes.string.isRequired,
  state: _react.PropTypes.object,
  key: _react.PropTypes.string
});

var historyContext = exports.historyContext = _react.PropTypes.shape({
  action: action.isRequired,
  location: location.isRequired,
  push: _react.PropTypes.func.isRequired,
  replace: _react.PropTypes.func.isRequired,
  go: _react.PropTypes.func.isRequired,
  goBack: _react.PropTypes.func.isRequired,
  goForward: _react.PropTypes.func.isRequired,
  canGo: _react.PropTypes.func,
  block: _react.PropTypes.func.isRequired
});