'use strict';

exports.__esModule = true;
exports.Forward = exports.Back = exports.Pop = exports.Replace = exports.Push = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _PropTypes = require('./PropTypes');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Action = function (_React$Component) {
  _inherits(Action, _React$Component);

  function Action() {
    _classCallCheck(this, Action);

    return _possibleConstructorReturn(this, _React$Component.apply(this, arguments));
  }

  Action.prototype.performAction = function performAction() {
    this.props.perform(this.context.history);
  };

  Action.prototype.componentDidMount = function componentDidMount() {
    this.performAction();
  };

  Action.prototype.componentDidUpdate = function componentDidUpdate() {
    this.performAction();
  };

  Action.prototype.render = function render() {
    return null;
  };

  return Action;
}(_react2.default.Component);

Action.contextTypes = {
  history: _PropTypes.historyContext.isRequired
};


if (process.env.NODE_ENV !== 'production') {
  Action.propTypes = {
    perform: _react.PropTypes.func.isRequired
  };
}

var Push = exports.Push = function Push(_ref) {
  var location = _ref.location;
  var path = _ref.path;
  var state = _ref.state;
  return _react2.default.createElement(Action, { perform: function perform(history) {
      return history.push(location || path, state);
    } });
};

if (process.env.NODE_ENV !== 'production') {
  Push.propTypes = {
    path: _react.PropTypes.string,
    state: _react.PropTypes.object,
    location: _react.PropTypes.shape({
      pathname: _react.PropTypes.string,
      search: _react.PropTypes.string,
      hash: _react.PropTypes.string,
      state: _react.PropTypes.object
    })
  };
}

var Replace = exports.Replace = function Replace(_ref2) {
  var location = _ref2.location;
  var path = _ref2.path;
  var state = _ref2.state;
  return _react2.default.createElement(Action, { perform: function perform(history) {
      return history.replace(location || path, state);
    } });
};

if (process.env.NODE_ENV !== 'production') Replace.propTypes = Push.propTypes;

var Pop = exports.Pop = function Pop(_ref3) {
  var go = _ref3.go;
  return _react2.default.createElement(Action, { perform: function perform(history) {
      return history.go(go);
    } });
};

if (process.env.NODE_ENV !== 'production') {
  Pop.propTypes = {
    go: _react.PropTypes.number
  };
}

Pop.defaultProps = {
  go: -1
};

var Back = exports.Back = function Back() {
  return _react2.default.createElement(Action, { perform: function perform(history) {
      return history.goBack();
    } });
};

var Forward = exports.Forward = function Forward() {
  return _react2.default.createElement(Action, { perform: function perform(history) {
      return history.goForward();
    } });
};