'use strict';

exports.__esModule = true;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _PropTypes = require('./PropTypes');

var _LocationUtils = require('./LocationUtils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var initialKeys = [undefined];

var ControlledHistory = function (_React$Component) {
  _inherits(ControlledHistory, _React$Component);

  ControlledHistory.prototype.getChildContext = function getChildContext() {
    return {
      history: this.props.history
    };
  };

  function ControlledHistory(props) {
    _classCallCheck(this, ControlledHistory);

    var _this = _possibleConstructorReturn(this, _React$Component.call(this, props));

    var location = props.history.location;
    var shouldRestoreKeys = !!location.key;
    _this.updatingFromHistoryChange = false;
    _this.syncingHistory = false;
    _this.keys = shouldRestoreKeys ? props.restoreKeys() : initialKeys;
    _this.setupHistory();
    _this.state = {
      location: location,
      action: 'POP'
    };
    return _this;
  }

  ControlledHistory.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
    if (!this.syncingHistory && !this.updatingFromHistoryChange && !(0, _LocationUtils.locationsAreEqual)(nextProps.location, this.props.location)) {
      this.syncingHistory = true;
      var history = this.props.history;
      var action = nextProps.action;
      var location = nextProps.location;

      var nextIndex = this.keys.indexOf(location.key);
      if (location.key && nextIndex !== -1) {
        // we've been here before
        var currentIndex = this.keys.indexOf(this.props.location.key);
        var delta = nextIndex - currentIndex;
        history.go(delta);
      } else if (action === 'PUSH') {
        history.push(location);
      } else if (action === 'REPLACE') {
        history.replace(location);
      }
    }
  };

  ControlledHistory.prototype.setupHistory = function setupHistory() {
    var _this2 = this;

    this.props.history.listen(function (location, action) {
      _this2.storeKey(location.key, action);
      _this2.updatingFromHistoryChange = true; // must come before onChange!
      if (_this2.syncingHistory) {
        _this2.props.onChange(location, 'SYNC');
      } else {
        _this2.props.onChange(location, action);
      }
      _this2.setState({ location: location, action: action }, function () {
        _this2.updatingFromHistoryChange = false;
        if (_this2.syncingHistory) {
          _this2.syncingHistory = false;
        } else {
          _this2.checkIfLocationAccepted();
        }
      });
    });
  };

  ControlledHistory.prototype.checkIfLocationAccepted = function checkIfLocationAccepted() {
    var location = this.props.location;
    var _state = this.state;
    var stateLocation = _state.location;
    var stateAction = _state.action;

    if (!(0, _LocationUtils.locationsAreEqual)(location, stateLocation)) {
      this.syncingHistory = true;
      var index = this.keys.indexOf(location.key);
      var stateIndex = this.keys.indexOf(stateLocation.key);
      var delta = index - stateIndex;
      if (stateAction === 'REPLACE') {
        this.props.history.replace(location);
      } else {
        if (stateIndex === -1) {
          // playing whack-a-mole here D: after we pop off the last key a
          // few lines down, if they click "forward" we won't find the key
          // so let's just do a -1 for delta.
          this.props.history.go(-1);
        } else {
          this.props.history.go(delta);
        }
        if (stateAction === 'PUSH') {
          // get rid of the last entry so our delta isn't off if they try to
          // push here again
          this.keys.pop();
        }
      }
    }
  };

  ControlledHistory.prototype.storeKey = function storeKey(key, action) {
    if (action === 'PUSH') {
      this.keys.push(key);
    } else if (action === 'REPLACE') {
      this.keys[this.keys.length - 1] = key;
    }
    // browsers only keep 50 entries, so we'll do that too
    if (this.keys.length > 50) this.keys.unshift();
    this.props.saveKeys(this.keys);
  };

  ControlledHistory.prototype.render = function render() {
    var _props = this.props;
    var history = _props.history;
    var location = _props.location;
    var action = _props.action;

    return this.props.children({
      history: history,
      location: location,
      action: action
    });
  };

  return ControlledHistory;
}(_react2.default.Component);

ControlledHistory.propTypes = {
  children: _react.PropTypes.func.isRequired,
  history: _react.PropTypes.object.isRequired,
  location: _react.PropTypes.object.isRequired,
  action: _react.PropTypes.string.isRequired,
  onChange: _react.PropTypes.func.isRequired,
  restoreKeys: _react.PropTypes.func.isRequired,
  saveKeys: _react.PropTypes.func.isRequired
};
ControlledHistory.childContextTypes = {
  history: _PropTypes.historyContext.isRequired
};
ControlledHistory.defaultProps = {
  restoreKeys: function restoreKeys() {
    return initialKeys;
  },
  saveKeys: function saveKeys() {}
};
exports.default = ControlledHistory;