'use strict';

exports.__esModule = true;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _PropTypes = require('./PropTypes');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * The common public API for all *History components.
 */
var History = function (_React$Component) {
  _inherits(History, _React$Component);

  function History() {
    _classCallCheck(this, History);

    return _possibleConstructorReturn(this, _React$Component.apply(this, arguments));
  }

  History.prototype.getChildContext = function getChildContext() {
    return {
      history: this.history
    };
  };

  History.prototype.componentWillMount = function componentWillMount() {
    var _this2 = this;

    var _props = this.props;
    var createHistory = _props.createHistory;
    var historyOptions = _props.historyOptions;

    this.history = createHistory(historyOptions);
    this.unlisten = this.history.listen(function () {
      return _this2.forceUpdate();
    });
  };

  History.prototype.componentWillUnmount = function componentWillUnmount() {
    this.unlisten();
  };

  History.prototype.render = function render() {
    var history = this.history;
    var location = history.location;
    var action = history.action;


    return this.props.children({
      history: history,
      location: location,
      action: action
    });
  };

  return History;
}(_react2.default.Component);

History.childContextTypes = {
  history: _PropTypes.historyContext.isRequired
};


if (process.env.NODE_ENV !== 'production') {
  History.propTypes = {
    children: _react.PropTypes.func.isRequired,
    createHistory: _react.PropTypes.func.isRequired,
    historyOptions: _react.PropTypes.object
  };
}

exports.default = History;