import { ResizeObserver as ResizeObserver$1 } from '@juggle/resize-observer';
import useLayoutEffect from '@react-hook/passive-layout-effect';
import useLatest from '@react-hook/latest';

/* eslint-disable no-return-assign */
var ResizeObserver = typeof window !== 'undefined' && 'ResizeObserver' in window ? // @ts-ignore
window.ResizeObserver : ResizeObserver$1;
/**
 * A React hook that fires a callback whenever ResizeObserver detects a change to its size
 *
 * @param target A React ref created by `useRef()` or an HTML element
 * @param callback Invoked with a single `ResizeObserverEntry` any time
 *   the `target` resizes
 */

function _ref() {}

function useResizeObserver(target, callback) {
  var resizeObserver = getResizeObserver();
  var storedCallback = useLatest(callback);
  useLayoutEffect(() => {
    var didUnsubscribe = false;
    var targetEl = target && 'current' in target ? target.current : target;
    if (!targetEl) return _ref;

    function cb(entry, observer) {
      if (didUnsubscribe) return;
      storedCallback.current(entry, observer);
    }

    resizeObserver.subscribe(targetEl, cb);
    return () => {
      didUnsubscribe = true;
      resizeObserver.unsubscribe(targetEl, cb);
    };
  }, [target, resizeObserver, storedCallback]);
  return resizeObserver.observer;
}

function createResizeObserver() {
  var ticking = false;
  var allEntries = [];
  var callbacks = new Map();
  var observer = new ResizeObserver((entries, obs) => {
    allEntries = allEntries.concat(entries);

    function _ref2() {
      var triggered = new Set();

      var _loop = function _loop(i) {
        if (triggered.has(allEntries[i].target)) return "continue";
        triggered.add(allEntries[i].target);
        var cbs = callbacks.get(allEntries[i].target);
        cbs === null || cbs === void 0 ? void 0 : cbs.forEach(cb => cb(allEntries[i], obs));
      };

      for (var i = 0; i < allEntries.length; i++) {
        var _ret = _loop(i);

        if (_ret === "continue") continue;
      }

      allEntries = [];
      ticking = false;
    }

    if (!ticking) {
      window.requestAnimationFrame(_ref2);
    }

    ticking = true;
  });
  return {
    observer,

    subscribe(target, callback) {
      var _callbacks$get;

      observer.observe(target);
      var cbs = (_callbacks$get = callbacks.get(target)) !== null && _callbacks$get !== void 0 ? _callbacks$get : [];
      cbs.push(callback);
      callbacks.set(target, cbs);
    },

    unsubscribe(target, callback) {
      var _callbacks$get2;

      var cbs = (_callbacks$get2 = callbacks.get(target)) !== null && _callbacks$get2 !== void 0 ? _callbacks$get2 : [];

      if (cbs.length === 1) {
        observer.unobserve(target);
        callbacks.delete(target);
        return;
      }

      var cbIndex = cbs.indexOf(callback);
      if (cbIndex !== -1) cbs.splice(cbIndex, 1);
      callbacks.set(target, cbs);
    }

  };
}

var _resizeObserver;

var getResizeObserver = () => !_resizeObserver ? _resizeObserver = createResizeObserver() : _resizeObserver;

export default useResizeObserver;
//# sourceMappingURL=index.dev.mjs.map
