import { useDebounce } from '@react-hook/debounce';
import useEvent from '@react-hook/event';

var emptyObj = {};
var win = typeof window === 'undefined' ? null : window;
var wv = win && typeof win.visualViewport !== 'undefined' ? win.visualViewport : null;

var getSize = () => [document.documentElement.clientWidth, document.documentElement.clientHeight];

var useWindowSize = function useWindowSize(options) {
  if (options === void 0) {
    options = emptyObj;
  }

  var {
    wait,
    leading,
    initialWidth = 0,
    initialHeight = 0
  } = options;
  var [size, setDebouncedSize] = useDebounce(
  /* istanbul ignore next */
  typeof document === 'undefined' ? [initialWidth, initialHeight] : getSize, wait, leading);

  var setSize = () => setDebouncedSize(getSize);

  useEvent(win, 'resize', setSize); // @ts-expect-error

  useEvent(wv, 'resize', setSize);
  useEvent(win, 'orientationchange', setSize);
  return size;
};
var useWindowHeight = options => useWindowSize(options)[1];
var useWindowWidth = options => useWindowSize(options)[0];

export { useWindowHeight, useWindowSize, useWindowWidth };
//# sourceMappingURL=index.dev.mjs.map
