"use strict";

exports.__esModule = true;
exports.useWindowWidth = exports.useWindowSize = exports.useWindowHeight = void 0;

var _debounce = /*#__PURE__*/require("@react-hook/debounce");

var _event = /*#__PURE__*/_interopRequireDefault( /*#__PURE__*/require("@react-hook/event"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const emptyObj = {};
const win = typeof window === 'undefined' ? null : window;
const wv = win && typeof win.visualViewport !== 'undefined' ? win.visualViewport : null;

const getSize = () => [document.documentElement.clientWidth, document.documentElement.clientHeight];

const useWindowSize = (options = emptyObj) => {
  const {
    wait,
    leading,
    initialWidth = 0,
    initialHeight = 0
  } = options;
  const [size, setDebouncedSize] = (0, _debounce.useDebounce)(
  /* istanbul ignore next */
  typeof document === 'undefined' ? [initialWidth, initialHeight] : getSize, wait, leading);

  const setSize = () => setDebouncedSize(getSize);

  (0, _event.default)(win, 'resize', setSize); // @ts-expect-error

  (0, _event.default)(wv, 'resize', setSize);
  (0, _event.default)(win, 'orientationchange', setSize);
  return size;
};

exports.useWindowSize = useWindowSize;

const useWindowHeight = options => useWindowSize(options)[1];

exports.useWindowHeight = useWindowHeight;

const useWindowWidth = options => useWindowSize(options)[0];

exports.useWindowWidth = useWindowWidth;