import { useThrottle } from '@react-hook/throttle';
import useEvent from '@react-hook/event';

/* eslint-disable import/no-extraneous-dependencies */
var emptyObj = {};
var win = typeof window === 'undefined' ? null : window;
var wv = win && typeof win.visualViewport !== 'undefined' ? win.visualViewport : null;

var getSize = () => [document.documentElement.clientWidth, document.documentElement.clientHeight];

var useWindowSize = function useWindowSize(options) {
  if (options === void 0) {
    options = emptyObj;
  }

  var {
    fps,
    leading,
    initialWidth = 0,
    initialHeight = 0
  } = options;
  var [size, setThrottledSize] = useThrottle(
  /* istanbul ignore next */
  typeof document === 'undefined' ? [initialWidth, initialHeight] : getSize, fps, leading);

  var setSize = () => setThrottledSize(getSize);

  useEvent(win, 'resize', setSize); // @ts-expect-error

  useEvent(wv, 'resize', setSize);
  useEvent(win, 'orientationchange', setSize);
  return size;
};
var useWindowHeight = options => useWindowSize(options)[1];
var useWindowWidth = options => useWindowSize(options)[0];

export { useWindowHeight, useWindowSize, useWindowWidth };
//# sourceMappingURL=index.dev.mjs.map
