"use strict";

exports.__esModule = true;
exports.useWindowWidth = exports.useWindowSize = exports.useWindowHeight = void 0;

var _throttle = /*#__PURE__*/require("@react-hook/throttle");

var _event = /*#__PURE__*/_interopRequireDefault( /*#__PURE__*/require("@react-hook/event"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint-disable import/no-extraneous-dependencies */
const emptyObj = {};
const win = typeof window === 'undefined' ? null : window;
const wv = win && typeof win.visualViewport !== 'undefined' ? win.visualViewport : null;

const getSize = () => [document.documentElement.clientWidth, document.documentElement.clientHeight];

const useWindowSize = (options = emptyObj) => {
  const {
    fps,
    leading,
    initialWidth = 0,
    initialHeight = 0
  } = options;
  const [size, setThrottledSize] = (0, _throttle.useThrottle)(
  /* istanbul ignore next */
  typeof document === 'undefined' ? [initialWidth, initialHeight] : getSize, fps, leading);

  const setSize = () => setThrottledSize(getSize);

  (0, _event.default)(win, 'resize', setSize); // @ts-expect-error

  (0, _event.default)(wv, 'resize', setSize);
  (0, _event.default)(win, 'orientationchange', setSize);
  return size;
};

exports.useWindowSize = useWindowSize;

const useWindowHeight = options => useWindowSize(options)[1];

exports.useWindowHeight = useWindowHeight;

const useWindowWidth = options => useWindowSize(options)[0];

exports.useWindowWidth = useWindowWidth;