var deepForceUpdate = require('./deepForceUpdate');

var isRequestPending = false;

module.exports = function requestForceUpdateAll(getRootInstances, React) {
  if (isRequestPending) {
    return;
  }

  /**
   * Forces deep re-render of all mounted React components.
   * Hats off to Omar Skalli (@Chetane) for suggesting this approach:
   * https://gist.github.com/Chetane/9a230a9fdcdca21a4e29
   */
  function forceUpdateAll() {
    isRequestPending = false;

    var rootInstances = getRootInstances(),
        rootInstance;

    for (var key in rootInstances) {
      if (rootInstances.hasOwnProperty(key)) {
        rootInstance = rootInstances[key];

        // `|| rootInstance` for React 0.12 and earlier
        rootInstance = rootInstance._reactInternalInstance || rootInstance;
        deepForceUpdate(rootInstance, React);
      }
    }
  }

  setTimeout(forceUpdateAll);
};
