"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withSSR = withSSR;

var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _useSSR = require("./useSSR");

var _context = require("./context");

function withSSR() {
  return function Extend(WrappedComponent) {
    function Wrapper(_ref) {
      var initialI18nStore = _ref.initialI18nStore,
          initialLanguage = _ref.initialLanguage,
          rest = (0, _objectWithoutProperties2.default)(_ref, ["initialI18nStore", "initialLanguage"]);
      (0, _useSSR.useSSR)(initialI18nStore, initialLanguage);
      return _react.default.createElement(WrappedComponent, (0, _objectSpread2.default)({}, rest));
    }

    Wrapper.getInitialProps = (0, _context.composeInitialProps)(WrappedComponent);
    return Wrapper;
  };
}