import _regeneratorRuntime from "@babel/runtime/regenerator";
import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _objectSpread from "@babel/runtime/helpers/objectSpread";
var defaultOptions = {
  bindI18n: 'languageChanged',
  transEmptyNodeValue: ''
};
var i18nInstance;
export function setDefaults() {
  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  defaultOptions = _objectSpread({}, defaultOptions, options);
}
export function getDefaults() {
  return defaultOptions;
}
var usedNamespaces = {};
export function addUsedNamespaces(namespaces) {
  namespaces.forEach(function (ns) {
    if (!usedNamespaces[ns]) usedNamespaces[ns] = true;
  });
}
export function getUsedNamespaces() {
  return Object.keys(usedNamespaces);
}
export function setI18n(instance) {
  i18nInstance = instance;
}
export function getI18n() {
  return i18nInstance;
}
export var initReactI18next = {
  type: '3rdParty',
  init: function init(instance) {
    setDefaults(instance.options.react);
    setI18n(instance);
  }
};
export function composeInitialProps(ForComponent) {
  return (
    /*#__PURE__*/
    function () {
      var _ref = _asyncToGenerator(
      /*#__PURE__*/
      _regeneratorRuntime.mark(function _callee(ctx) {
        var componentsInitialProps, i18nInitialProps;
        return _regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                if (!ForComponent.getInitialProps) {
                  _context.next = 6;
                  break;
                }

                _context.next = 3;
                return ForComponent.getInitialProps(ctx);

              case 3:
                _context.t0 = _context.sent;
                _context.next = 7;
                break;

              case 6:
                _context.t0 = {};

              case 7:
                componentsInitialProps = _context.t0;
                i18nInitialProps = getInitialProps();
                return _context.abrupt("return", _objectSpread({}, componentsInitialProps, i18nInitialProps));

              case 10:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }()
  );
}
export function getInitialProps() {
  var i18n = getI18n();
  var namespaces = getUsedNamespaces();
  var ret = {};
  var initialI18nStore = {};
  i18n.languages.forEach(function (l) {
    initialI18nStore[l] = {};
    namespaces.forEach(function (ns) {
      initialI18nStore[l][ns] = i18n.getResourceBundle(l, ns) || {};
    });
  });
  ret.initialI18nStore = initialI18nStore;
  ret.initialLanguage = i18n.language;
  return ret;
}