import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _objectSpread from "@babel/runtime/helpers/objectSpread";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import React, { Component } from 'react';
import hoistStatics from 'hoist-non-react-statics';
import { shallowEqual } from './utils';
import { withI18n, setDefaults, setI18n } from './context';
import { NamespacesConsumer } from './NamespacesConsumer';

function getDisplayName(component) {
  return component.displayName || component.name || 'Component';
}

export function withNamespaces(namespaceArg) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  return function Wrapper(WrappedComponent) {
    var LoadNamespace =
    /*#__PURE__*/
    function (_Component) {
      _inherits(LoadNamespace, _Component);

      function LoadNamespace() {
        _classCallCheck(this, LoadNamespace);

        return _possibleConstructorReturn(this, _getPrototypeOf(LoadNamespace).apply(this, arguments));
      }

      _createClass(LoadNamespace, [{
        key: "shouldComponentUpdate",
        value: function shouldComponentUpdate(nextProps) {
          var i18nOptions = this.props.i18nOptions;

          if (!i18nOptions.usePureComponent && !options.usePureComponent) {
            return true;
          }

          return !shallowEqual(this.props, nextProps);
        }
      }, {
        key: "render",
        value: function render() {
          var _this = this;

          var _this$props = this.props,
              namespaces = _this$props.namespaces,
              i18nOptions = _this$props.i18nOptions;

          var mergedI18nOptions = _objectSpread({}, i18nOptions, options);

          var extraProps = {};

          if (mergedI18nOptions.innerRef) {
            extraProps.ref = mergedI18nOptions.innerRef;
          }

          return React.createElement(NamespacesConsumer, _objectSpread({
            ns: namespaces || namespaceArg
          }, this.props, {
            i18nOptions: Object.keys(mergedI18nOptions).length > 0 ? mergedI18nOptions : null
          }), function (t, _ref) {
            var ready = _ref.ready,
                rest = _objectWithoutProperties(_ref, ["ready"]);

            return React.createElement(WrappedComponent, _objectSpread({
              tReady: ready
            }, _this.props, extraProps, rest));
          });
        }
      }]);

      return LoadNamespace;
    }(Component);

    var LoadNamespaceWithContext = withI18n()(LoadNamespace);
    LoadNamespaceWithContext.WrappedComponent = WrappedComponent;
    LoadNamespaceWithContext.displayName = "LoadNamespace(".concat(getDisplayName(WrappedComponent), ")");
    LoadNamespaceWithContext.namespaces = namespaceArg;
    return hoistStatics(LoadNamespaceWithContext, WrappedComponent);
  };
}
withNamespaces.setDefaults = setDefaults;
withNamespaces.setI18n = setI18n;
export var translate = withNamespaces;