'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var PropTypes = _react2['default'].PropTypes;
var _React$DOM = _react2['default'].DOM;
var span = _React$DOM.span;
var img = _React$DOM.img;
var noscript = _React$DOM.noscript;

var Status = {
  PENDING: 'pending',
  LOADING: 'loading',
  LOADED: 'loaded',
  FAILED: 'failed'
};

function hasSize(i) {
  return i.naturalWidth + i.naturalHeight === 0 || i.width + i.height === 0;
}

function renderToStaticMarkup(el) {
  return (_react2['default'].renderToStaticMarkup || _react2['default'].renderComponentToStaticMarkup)(el);
}

var id = function id(x) {
  return x;
};

var createFactory = function createFactory(cls) {
  return (_react2['default'].createFactory || id)(cls);
};

var ImageLoaderImg = createFactory(_react2['default'].createClass({
  displayName: 'ImageLoaderImage',

  getInitialState: function getInitialState() {
    // We don't want to render the image on the server, because that will result
    // in the <img> tag being serialized the DOM causing the browser to start
    // loading the image before this component mounts on the client. Since the
    // point of this component is to exert control over the image load, we want
    // to avoid that.
    //
    // However, initially rendering different things on the server and the client
    // is a big no-no (invariant), so we need to also treat the first render on
    // the client like we do on the server. Only then, once we know we're in the
    // client environment, can we safely render with actual <img> tag.
    //
    // So, to achieve client-server parity, we track our own `isInitialRender`
    // state (we can't use `isMounted()`, since that will be true at the time of
    // initial render on the client, but not the server).
    return { isInitialRender: true };
  },

  componentDidMount: function componentDidMount() {
    // FIXME: Is there a way to avoid setting state on mount?
    this.setState({ isInitialRender: false });
  },

  handleLoad: function handleLoad() {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    if (!this.isMounted()) return;
    var image = this.refs.image;

    if (Object.hasOwnProperty(image, 'naturalWidth') && !hasSize(image)) {
      this.handleError(new Error('Image <' + image.src + '> could not be loaded.'));
    } else if (this.props.onLoad) {
      var _props;

      (_props = this.props).onLoad.apply(_props, args);
    }
  },

  handleError: function handleError() {
    var _props2;

    for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    if (this.props.onError) (_props2 = this.props).onError.apply(_props2, args);
  },

  renderImg: function renderImg() {
    var props = Object.assign({}, this.props, {
      ref: 'image',
      onLoad: this.handleLoad,
      onError: this.handleError
    });
    return _react2['default'].createElement('img', props);
  },

  render: function render() {
    if (this.state.isInitialRender) {
      // We will initially render the <img> tag in a <noscript> (see note in
      // `getInitialState` for reasons). This will increase accessibility in that
      // rare case when the serialized component is served to a browser with
      // javascript disabled, but ensure that the image won't start loading
      // before we're ready. However, there is an issue
      // (https://github.com/facebook/react/issues/1252) that causes noscript to
      // cause invariant violations when rendered on the server. So, we render it
      // as a string and set the inner HTML of a wrapper span.
      var html = renderToStaticMarkup(_react2['default'].createElement(
        'noscript',
        null,
        this.renderImg()
      ));
      return _react2['default'].createElement('span', {
        style: { display: 'none' },
        dangerouslySetInnerHTML: { __html: html } });
    } else {
      return this.renderImg();
    }
  }
}));

var ImageLoader = _react2['default'].createClass({
  displayName: 'ImageLoader',
  // mixins: [ReactLoaderMixin]  // FIXME: get rid of this!
  propTypes: {
    wrapper: PropTypes.func,
    preloader: PropTypes.func,
    onLoad: PropTypes.func,
    onError: PropTypes.func
  },

  getInitialState: function getInitialState() {
    return { status: Status.PENDING };
  },

  getDefaultProps: function getDefaultProps() {
    return {
      wrapper: span,
      loader: ImageLoaderImg
    };
  },

  componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
    if (this.props.src !== nextProps.src) {
      this.setState({
        status: nextProps.src ? Status.LOADING : Status.PENDING
      });
    }
  },

  getClassName: function getClassName() {
    var className = 'imageloader ' + this.state.status;
    if (this.props.className) className = '' + className + ' ' + this.props.className;
    return className;
  },

  getImgProps: function getImgProps() {
    var props = Object.assign({}, this.props, {
      style: Object.assign({}, this.props.style, {
        display: this.state.status === Status.LOADED ? null : 'none'
      })
    });
    delete props.wrapper;
    delete props.preloader;
    delete props.children;
    return props;
  },

  loaderDidLoad: function loaderDidLoad() {
    this.setState({ status: Status.LOADED });
  },

  loaderDidError: function loaderDidError() {
    this.setState({ status: Status.FAILED });
  },

  renderChildren: function renderChildren() {
    if (Array.isArray(this.props.children)) return this.props.children.slice();
    return [this.props.children];
  },

  render: function render() {
    var _props3;

    var wrapperArgs = [{ className: this.getClassName() }];
    if (this.props.src) {
      wrapperArgs.push(this.renderLoader(ImageLoaderImg, this.getImgProps()));
    }
    if (this.props.preloader && this.state.status !== Status.LOADED && this.state.status !== Status.FAILED) {
      wrapperArgs.push(this.props.preloader());
    }
    if (this.state.status === Status.FAILED) {
      wrapperArgs = wrapperArgs.concat(this.renderChildren());
    }
    return (_props3 = this.props).wrapper.apply(_props3, _toConsumableArray(wrapperArgs));
  }
});

exports['default'] = ImageLoader;
module.exports = exports['default'];