'use strict';

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _noImportant = require('aphrodite/no-important');

var _Thumbnail = require('./Thumbnail');

var _Thumbnail2 = _interopRequireDefault(_Thumbnail);

var _theme = require('../theme');

var _theme2 = _interopRequireDefault(_theme);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function Thumbnails(_ref) {
	var currentImage = _ref.currentImage,
	    images = _ref.images,
	    onClickThumbnail = _ref.onClickThumbnail;

	return _react2.default.createElement(
		'div',
		{ className: (0, _noImportant.css)(classes.thumbnails) },
		images.map(function (img, idx) {
			return _react2.default.createElement(_Thumbnail2.default, _extends({}, img, {
				active: idx === currentImage,
				index: idx,
				key: idx,
				onClick: onClickThumbnail
			}));
		})
	);
}

Thumbnails.propTypes = {
	currentImage: _propTypes2.default.number,
	images: _propTypes2.default.array,
	onClickThumbnail: _propTypes2.default.func.isRequired
};

var classes = _noImportant.StyleSheet.create({
	thumbnails: {
		bottom: _theme2.default.container.gutter.vertical,
		color: 'white',
		height: _theme2.default.thumbnail.size,
		left: _theme2.default.container.gutter.horizontal,
		overflowX: 'scroll',
		overflowY: 'hidden',
		position: 'absolute',
		right: _theme2.default.container.gutter.horizontal,
		textAlign: 'center',
		whiteSpace: 'nowrap'
	}
});

exports.default = Thumbnails;