/*
 * Copyright 2015, Yahoo Inc.
 * Copyrights licensed under the New BSD License.
 * See the accompanying LICENSE file for terms.
 */

import React, {Component, PropTypes} from 'react';
import {intlShape, pluralFormatPropTypes} from '../types';
import {assertIntlContext, shouldIntlComponentUpdate} from '../utils';

export default class FormattedPlural extends Component {
    constructor(props, context) {
        super(props, context);
        assertIntlContext(context);
    }

    shouldComponentUpdate(...next) {
        return shouldIntlComponentUpdate(this, ...next);
    }

    render() {
        const {formatPlural} = this.context.intl;
        const props          = this.props;

        let pluralCategory  = formatPlural(props.value, props);
        let formattedPlural = props[pluralCategory] || props.other;

        if (typeof props.children === 'function') {
            return props.children(formattedPlural);
        }

        return <span>{formattedPlural}</span>;
    }
}

FormattedPlural.propTypes = {
    ...pluralFormatPropTypes,
    value: PropTypes.any.isRequired,

    // TODO: Should these be functions instead nodes (or?), so that complex
    // nested elements don't have to incur the cost of rendering when they are
    // not used?
    other: PropTypes.node.isRequired,
    zero : PropTypes.node,
    one  : PropTypes.node,
    two  : PropTypes.node,
    few  : PropTypes.node,
    many : PropTypes.node,
};

FormattedPlural.defaultProps = {
    style: 'cardinal',
};

FormattedPlural.contextTypes = {
    intl: intlShape,
};
