"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _utils = require("../../utils");

var _widgetsCheckboxWidget = require("./../widgets/CheckboxWidget");

var _widgetsCheckboxWidget2 = _interopRequireDefault(_widgetsCheckboxWidget);

function BooleanField(_ref) {
  var schema = _ref.schema;
  var name = _ref.name;
  var uiSchema = _ref.uiSchema;
  var formData = _ref.formData;
  var required = _ref.required;
  var onChange = _ref.onChange;
  var title = schema.title;
  var description = schema.description;

  var widget = uiSchema["ui:widget"];
  var commonProps = {
    schema: schema,
    onChange: onChange,
    label: title || name,
    placeholder: description,
    defaultValue: schema["default"],
    value: (0, _utils.defaultFieldValue)(formData, schema),
    required: required
  };
  if (widget) {
    var Widget = (0, _utils.getAlternativeWidget)(schema.type, widget);
    return _react2["default"].createElement(Widget, _extends({ options: [true, false] }, commonProps));
  }
  return _react2["default"].createElement(_widgetsCheckboxWidget2["default"], commonProps);
}

if (process.env.NODE_ENV !== "production") {
  BooleanField.propTypes = {
    schema: _react.PropTypes.object.isRequired,
    uiSchema: _react.PropTypes.object,
    onChange: _react.PropTypes.func.isRequired,
    formData: _react.PropTypes.bool,
    required: _react.PropTypes.bool
  };
}

BooleanField.defaultProps = {
  uiSchema: {}
};

exports["default"] = BooleanField;
module.exports = exports["default"];