"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _utils = require("../../utils");

/**
 * This is a silly limitation in the DOM where option change event values are
 * always retrieved as strings.
 */
function processValue(type, value) {
  if (type === "boolean") {
    return value === "true";
  } else if (type === "number") {
    return (0, _utils.asNumber)(value);
  }
  return value;
}

function SelectWidget(_ref) {
  var schema = _ref.schema;
  var options = _ref.options;
  var placeholder = _ref.placeholder;
  var value = _ref.value;
  var defaultValue = _ref.defaultValue;
  var required = _ref.required;
  var onChange = _ref.onChange;

  return _react2["default"].createElement(
    "select",
    {
      title: placeholder,
      value: value,
      defaultValue: defaultValue,
      onChange: function (event) {
        onChange(processValue(schema.type, event.target.value));
      } },
    options.map(function (option, i) {
      return _react2["default"].createElement(
        "option",
        { key: i, value: option },
        String(option)
      );
    })
  );
}

if (process.env.NODE_ENV !== "production") {
  SelectWidget.propTypes = {
    schema: _react.PropTypes.object.isRequired,
    options: _react.PropTypes.array.isRequired,
    placeholder: _react.PropTypes.string,
    value: _react.PropTypes.any,
    defaultValue: _react.PropTypes.any,
    required: _react.PropTypes.bool,
    onChange: _react.PropTypes.func
  };
}

exports["default"] = SelectWidget;
module.exports = exports["default"];