'use strict';

exports.__esModule = true;
var _slice = Array.prototype.slice;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

exports['default'] = useSheet;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _jss = require('jss');

var _jss2 = _interopRequireDefault(_jss);

function decorate(DecoratedComponent, rules) {
  var options = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

  var refs = 0;
  var sheet = null;

  function attach() {
    if (!sheet) sheet = (options.jss || _jss2['default']).createStyleSheet(rules, options);

    sheet.attach();
  }

  function detach() {
    sheet.detach();
  }

  function ref() {
    if (refs === 0) attach();

    refs++;
    return sheet;
  }

  function deref() {
    refs--;

    if (refs === 0) detach();
  }

  var displayName = DecoratedComponent.displayName || DecoratedComponent.name || 'Component';

  return (function () {
    function StyleSheetWrapper() {
      _classCallCheck(this, StyleSheetWrapper);
    }

    StyleSheetWrapper.prototype.componentWillMount = function componentWillMount() {
      this.sheet = ref();
    };

    StyleSheetWrapper.prototype.componentWillUpdate = function componentWillUpdate() {
      if (process.env.NODE_ENV !== 'production') {
        // Support React Hot Loader
        if (this.sheet !== sheet) {
          this.sheet.detach();
          this.sheet = ref();
        }
      }
    };

    StyleSheetWrapper.prototype.componentWillUnmount = function componentWillUnmount() {
      deref();
      this.sheet = null;
    };

    StyleSheetWrapper.prototype.render = function render() {
      return _react2['default'].createElement(DecoratedComponent, _extends({}, this.props, { sheet: this.sheet }));
    };

    _createClass(StyleSheetWrapper, null, [{
      key: 'wrapped',
      value: DecoratedComponent,
      enumerable: true
    }, {
      key: 'displayName',
      value: 'JSS(' + displayName + ')',
      enumerable: true
    }]);

    return StyleSheetWrapper;
  })();
}

function useSheet(rulesOrComponentOrJss) {
  var _arguments = arguments;

  if (rulesOrComponentOrJss instanceof _jss2['default'].Jss) {
    return function (component) {
      var rules = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
      var options = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

      if (typeof component != 'function') {
        rules = component;
        options = rules;
      }
      options.jss = rulesOrComponentOrJss;
      return useSheet(component, rules, options);
    };
  }

  if (typeof rulesOrComponentOrJss === 'function') {
    return decorate.apply(undefined, arguments);
  }

  return function (DecoratedComponent) {
    return decorate.apply(undefined, [DecoratedComponent].concat(_slice.call(_arguments)));
  };
}

module.exports = exports['default'];