'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.default = useSheet;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _jss2 = require('jss');

var _jss3 = _interopRequireDefault(_jss2);

var _hoistNonReactStatics = require('hoist-non-react-statics');

var _hoistNonReactStatics2 = _interopRequireDefault(_hoistNonReactStatics);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function decorate(DecoratedComponent, rules, options) {
  var _jss = arguments.length <= 3 || arguments[3] === undefined ? _jss3.default : arguments[3];

  var refs = 0;
  var sheet = null;

  function attach() {
    if (!sheet) sheet = _jss.createStyleSheet(rules, options);
    sheet.attach();
  }

  function detach() {
    sheet.detach();
  }

  function ref() {
    if (refs === 0) attach();
    refs++;
    return sheet;
  }

  function deref() {
    refs--;
    if (refs === 0) detach();
  }

  var displayName = DecoratedComponent.displayName || DecoratedComponent.name || 'Component';

  var StyleSheetWrapper = function (_React$Component) {
    _inherits(StyleSheetWrapper, _React$Component);

    function StyleSheetWrapper() {
      _classCallCheck(this, StyleSheetWrapper);

      return _possibleConstructorReturn(this, Object.getPrototypeOf(StyleSheetWrapper).apply(this, arguments));
    }

    _createClass(StyleSheetWrapper, [{
      key: 'componentWillMount',
      value: function componentWillMount() {
        this.sheet = ref();
      }
    }, {
      key: 'componentWillUpdate',
      value: function componentWillUpdate() {
        if (process.env.NODE_ENV !== 'production') {
          // Support React Hot Loader.
          if (this.sheet !== sheet) {
            this.sheet.detach();
            this.sheet = ref();
          }
        }
      }
    }, {
      key: 'componentWillUnmount',
      value: function componentWillUnmount() {
        deref();
        this.sheet = null;
      }
    }, {
      key: 'render',
      value: function render() {
        return _react2.default.createElement(DecoratedComponent, _extends({}, this.props, { sheet: this.sheet }));
      }
    }]);

    return StyleSheetWrapper;
  }(_react2.default.Component);

  StyleSheetWrapper.wrapped = DecoratedComponent;
  StyleSheetWrapper.displayName = 'JSS(' + displayName + ')';


  return (0, _hoistNonReactStatics2.default)(StyleSheetWrapper, DecoratedComponent, {
    wrapped: true
  });
}

/**
 * It has 3 different use cases:
 *
 * - binding to a specific jss version `useSheet(jss)`, returns a bound useSheet
 * function, default is the global jss instance
 * - manual decoration `useSheet(Component, rules, options)`
 * - decoration by @decorator, which produces `useSheet(rules, options)(Component)`
 */
function useSheet(DecoratedComponent, rules, options) {
  // User creates a useSheet function bound to a specific jss version.
  // DecoratedComponent is Jss instance.
  if (DecoratedComponent instanceof _jss3.default.constructor && !rules) {
    return useSheet.bind(DecoratedComponent);
  }

  var customJss = this instanceof _jss3.default.constructor ? this : undefined;

  // Manually called by user: `useSheet(DecoratedComponent, rules, options)`.
  if (typeof DecoratedComponent === 'function') {
    return decorate(DecoratedComponent, rules, options, customJss);
  }

  // Used as a decorator: `useSheet(rules, options)(DecoratedComponent)`.
  options = rules;
  rules = DecoratedComponent;

  return function (_DecoratedComponent) {
    return decorate(_DecoratedComponent, rules, options, customJss);
  };
}

// Hotfix for babel 5 migration, will be removed in the next major version.
module.exports = exports = useSheet;