"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

/**
 * Adds `composes` property to each top level rule
 * in order to have a composed class name for dynamic style sheets.
 *
 * @param {StyleSheet} staticSheet
 * @param {Object} styles
 * @return {Object|null}
 */
exports["default"] = function (staticSheet, styles) {
  for (var name in styles) {
    var className = staticSheet.classes[name];
    if (!className) break;
    styles[name] = _extends({}, styles[name], { composes: className });
  }

  if (styles) {
    for (var _name in staticSheet.classes) {
      var _className = styles[_name];
      if (!_className) {
        styles[_name] = { composes: staticSheet.classes[_name] };
      }
    }
  }

  return styles;
};