# Contributing

You want to contribute? Great! Please read below the instructions for the different types of contributions.

## Bug reports

Please fill the issue template with steps to reproduce.

## Pull requests

Pull requests are more than welcome to fix issues and improve documentation, test coverage and features parity with Leaflet.  
However, please **do not** send pull requests to add features that are not supported by Leaflet. If you want to add support for plugins, please create separate repositories for this.

## Features requests

This library aims only to support the features provided by Leaflet. If any of these features is not implemented yet, please submit a feature request to add it.
If you are looking for implementations of features provided by plugins, they will not be provided by this library. Please read the [creating custom components](#creating-custom-components) section of the documentation to see how to implement plugins in your own code.

## Other issues

Please check among existing issues (open **and** closed) if the problem you encounter has not been solved before.  
If you have questions about React or Leaflet not directly related to this library, please ask them using their respective support platforms.  
For any other issue, please provide a simple description, if relevant with codes examples. You can use [this jsfiddle](https://jsfiddle.net/paul_lecam/q2v7t59h/) as a starting example.
