(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "react", "./css/Triangle.css"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("react"), require("./css/Triangle.css"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.react, global.Triangle);
    global.Triangle = mod.exports;
  }
})(this, function (exports, _react) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.Triangle = undefined;

  var _react2 = _interopRequireDefault(_react);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  var Triangle = exports.Triangle = function Triangle(svg) {
    return _react2.default.createElement(
      "div",
      { className: "react-spinner-loader-svg" },
      _react2.default.createElement(
        "svg",
        { id: "triangle", width: svg.height, height: svg.height, viewBox: "-3 -4 39 39" },
        _react2.default.createElement("polygon", { fill: "transparent", stroke: svg.color, strokeWidth: "1", points: "16,0 32,32 0,32" })
      )
    );
  };
});