"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactTransitionGroup = require("react-transition-group");

var _emotion = require("emotion");

var _Spinner = _interopRequireDefault(require("./components/Spinner"));

var _styles = _interopRequireDefault(require("./styles"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var LoadingOverlayWrapper =
/*#__PURE__*/
function (_Component) {
  _inherits(LoadingOverlayWrapper, _Component);

  function LoadingOverlayWrapper(props) {
    var _this;

    _classCallCheck(this, LoadingOverlayWrapper);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(LoadingOverlayWrapper).call(this, props));

    _defineProperty(_assertThisInitialized(_assertThisInitialized(_this)), "getStyles", function (key, providedState) {
      var base = _styles.default[key](providedState, _this.props);

      var custom = _this.props.styles[key];
      if (!custom) return base;
      return typeof custom === 'function' ? custom(base, _this.props) : custom;
    });

    _defineProperty(_assertThisInitialized(_assertThisInitialized(_this)), "cx", function (names) {
      var arr = Array.isArray(names) ? names : [names];

      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      return _emotion.cx.apply(void 0, _toConsumableArray(arr.map(function (name) {
        return name ? "".concat(_this.props.classNamePrefix).concat(name) : '';
      })).concat(args));
    });

    _this.wrapper = _react.default.createRef();
    _this.state = {
      overflowCSS: {}
    };
    return _this;
  }

  _createClass(LoadingOverlayWrapper, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var wrapperStyle = window.getComputedStyle(this.wrapper.current);
      var overflowCSS = ['overflow', 'overflowX', 'overflowY'].reduce(function (m, i) {
        if (wrapperStyle[i] !== 'visible') m[i] = 'hidden';
        return m;
      }, {});
      this.setState({
        overflowCSS: overflowCSS
      });
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var active = this.props.active;
      if (active) this.wrapper.current.scrollTop = 0;
    }
    /**
     * Return an emotion css object for a given element key
     * If a custom style was provided via props, run it with
     * the base css obj.
     */

  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var overflowCSS = this.state.overflowCSS;
      var _this$props = this.props,
          children = _this$props.children,
          className = _this$props.className,
          onClick = _this$props.onClick,
          active = _this$props.active,
          fadeSpeed = _this$props.fadeSpeed,
          spinner = _this$props.spinner,
          text = _this$props.text;
      return _react.default.createElement("div", {
        "data-testid": "wrapper",
        ref: this.wrapper,
        className: this.cx(['wrapper', active && 'wrapper--active'], (0, _emotion.css)(this.getStyles('wrapper', active ? overflowCSS : {})), className)
      }, _react.default.createElement(_reactTransitionGroup.CSSTransition, {
        in: active,
        classNames: "_loading-overlay-transition",
        timeout: fadeSpeed,
        unmountOnExit: true
      }, function (state) {
        return _react.default.createElement("div", {
          "data-testid": "overlay",
          className: _this2.cx('overlay', (0, _emotion.css)(_this2.getStyles('overlay', state))),
          onClick: onClick
        }, _react.default.createElement("div", {
          className: _this2.cx('content', (0, _emotion.css)(_this2.getStyles('content')))
        }, spinner && (typeof spinner === 'boolean' ? _react.default.createElement(_Spinner.default, {
          cx: _this2.cx,
          getStyles: _this2.getStyles
        }) : spinner), text));
      }), children);
    }
  }]);

  return LoadingOverlayWrapper;
}(_react.Component);

LoadingOverlayWrapper.propTypes = {
  active: _propTypes.default.bool,
  fadeSpeed: _propTypes.default.number,
  onClick: _propTypes.default.func,
  className: _propTypes.default.string,
  classNamePrefix: _propTypes.default.string,
  spinner: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.node]),
  text: _propTypes.default.node,
  styles: _propTypes.default.shape({
    content: _propTypes.default.function,
    overlay: _propTypes.default.function,
    spinner: _propTypes.default.function,
    wrapper: _propTypes.default.function
  })
};
LoadingOverlayWrapper.defaultProps = {
  classNamePrefix: '_loading_overlay_',
  fadeSpeed: 500,
  styles: {}
};
var _default = LoadingOverlayWrapper;
exports.default = _default;