"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _emotion = require("emotion");

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _templateObject2() {
  var data = _taggedTemplateLiteral(["\n  0% {\n    stroke-dasharray: 1,200;\n    stroke-dashoffset: 0;\n  }\n  50% {\n    stroke-dasharray: 89,200;\n    stroke-dashoffset: -35px;\n  }\n  100% {\n    stroke-dasharray: 89,200;\n    stroke-dashoffset: -124px;\n  }\n"]);

  _templateObject2 = function _templateObject2() {
    return data;
  };

  return data;
}

function _templateObject() {
  var data = _taggedTemplateLiteral(["\n  from {\n    transform: rotate(0deg);\n  }\n  to {\n    transform: rotate(360deg);\n  }\n"]);

  _templateObject = function _templateObject() {
    return data;
  };

  return data;
}

function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }

var rotate360 = (0, _emotion.keyframes)(_templateObject());
var spinnerDash = (0, _emotion.keyframes)(_templateObject2());
var _default = {
  wrapper: function wrapper(state) {
    return _objectSpread({
      position: 'relative'
    }, state);
  },
  overlay: function overlay(state, props) {
    return {
      position: 'absolute',
      height: '100%',
      width: '100%',
      top: '0px',
      left: '0px',
      display: 'flex',
      textAlign: 'center',
      fontSize: '1.2em',
      color: '#FFF',
      background: 'rgba(0, 0, 0, 0.7)',
      zIndex: 800,
      transition: "opacity ".concat(props.fadeSpeed, "ms ease-in"),
      opacity: state === 'entering' || state === 'entered' ? 1 : 0
    };
  },
  content: function content() {
    return {
      margin: 'auto'
    };
  },
  spinner: function spinner(state) {
    return {
      position: 'relative',
      margin: '0px auto 10px auto',
      width: '50px',
      maxHeight: '100%',
      '&:before': {
        content: '""',
        display: 'block',
        paddingTop: '100%'
      },
      '& svg': {
        animation: "".concat(rotate360, " 2s linear infinite"),
        height: '100%',
        transformOrigin: 'center center',
        width: '100%',
        position: 'absolute',
        top: '0',
        bottom: '0',
        left: '0',
        right: '0',
        margin: 'auto',
        '& circle': {
          animation: "".concat(spinnerDash, " 1.5s ease-in-out infinite"),
          strokeDasharray: '1,200',
          strokeDashoffset: 0,
          strokeLinecap: 'round',
          stroke: '#FFF'
        }
      }
    };
  }
};
exports.default = _default;