"use strict";

var _require = require('./constants'),
  PACKAGE_NAME = _require.PACKAGE_NAME,
  PACKAGE_FUNCTION = _require.PACKAGE_FUNCTION,
  HOC_FUNCTION = _require.HOC_FUNCTION;
var processDIReference = require('./processor-di');
var processHOCReference = require('./processor-hoc');
var _require2 = require('./utils'),
  isEnabledEnv = _require2.isEnabledEnv;
module.exports = function (babel) {
  var t = babel.types;
  return {
    visitor: {
      ImportDeclaration: function ImportDeclaration(path, _ref) {
        var _ref$opts = _ref.opts,
          opts = _ref$opts === void 0 ? {} : _ref$opts;
        // first we look at the imports:
        // if not our package and not the right function, ignore
        var importSource = path.node.source.value;
        var importDISpecifier = path.node.specifiers.find(function (s) {
          return s.imported && s.imported.name === PACKAGE_FUNCTION;
        });
        var importHOCSpecifier = path.node.specifiers.find(function (s) {
          return s.imported && s.imported.name === HOC_FUNCTION;
        });
        if (importSource !== PACKAGE_NAME) return;
        if (importDISpecifier) {
          // then we locate all usages of the method
          // ensuring we affect only locations where it is called
          var methodIdentifier = importDISpecifier.local.name;
          var binding = path.scope.getBinding(methodIdentifier);
          if (!binding) return;
          var references = binding.referencePaths.filter(function (ref) {
            return t.isCallExpression(ref.container);
          });
          var isEnabled = isEnabledEnv() || Boolean(opts.forceEnable);

          // for each of that location we apply a tranformation
          references.forEach(function (ref) {
            return processDIReference(t, ref, isEnabled);
          });
        }
        if (importHOCSpecifier) {
          // then we locate all usages of the method
          // ensuring we affect only locations where it is called
          var _methodIdentifier = importHOCSpecifier.local.name;
          var _binding = path.scope.getBinding(_methodIdentifier);
          if (!_binding) return;
          var _references = _binding.referencePaths.filter(function (ref) {
            return t.isCallExpression(ref.container);
          });

          // for each of that location we apply a tranformation
          _references.forEach(function (ref) {
            return processHOCReference(t, ref);
          });
        }
      }
    }
  };
};