"use strict";

var _require = require('../utils'),
  getDiIdentifier = _require.getDiIdentifier,
  getDiStatements = _require.getDiStatements,
  getDiVars = _require.getDiVars;
module.exports = {
  meta: {
    type: 'problem',
    docs: {
      description: 'Disallow dependencies to be marked as injectable more than once',
      category: 'Possible Errors',
      recommended: true
    },
    // fixable: 'code',
    schema: [],
    messages: {
      duplicatedInjectable: "The dependency '{{name}}' has been marked as injectable more than once. " + 'Please ensure it is listed only on one di(...) call'
    }
  },
  create: function create(context) {
    var diIdentifier;
    var report = function report(node) {
      return context.report({
        node: node,
        messageId: 'duplicatedInjectable',
        data: {
          name: node.name
        }
      });
    };
    return {
      ImportDeclaration: function ImportDeclaration(node) {
        if (!diIdentifier) diIdentifier = getDiIdentifier(node);
      },
      BlockStatement: function BlockStatement(node) {
        if (!diIdentifier) return;
        var diStatements = getDiStatements(node, diIdentifier);
        // ignore locations where di was not explicitly set
        if (!diStatements.length) return;
        var dupeDiVars = getDiVars(diStatements).filter(function (id, i, arr) {
          return arr.findIndex(function (n) {
            return n.name === id.name;
          }) !== i;
        });
        dupeDiVars.forEach(report);
      }
    };
  }
};