"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.di = di;
var _constants = require("./constants");
var _context = require("./context");
var _global = require("./global");
var _utils = require("./utils");
function di(deps, target) {
  // check if babel plugin has been added
  if (Array.isArray(deps)) {
    // Read context and grab all the dependencies override Providers in the tree
    var _ref =
      // grab value from alt renderer (eg react-test-renderer)
      _context.Context._currentRenderer2 && _context.Context._currentValue2 ||
      // grab value from default renderer
      _context.Context._currentValue || _global.globalDi,
      getDependencies = _ref.getDependencies;
    return getDependencies(deps, target);
  } else {
    (0, _utils.warnOnce)("Seems like you are using ".concat(_constants.PACKAGE_NAME, " without Babel plugin. ") + "Please add '".concat(_constants.PACKAGE_NAME, "/babel-plugin' to your Babel config ") + "or import from '".concat(_constants.PACKAGE_NAME, "/macro' if your are using 'babel-plugin-macros'. ") + 'di(...) run as a no-op.');
  }
}

/** @deprecated use injectable instead */
di.mock = _utils.mock;