"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.globalDi = void 0;
exports.runWithDi = runWithDi;
var _constants = require("./constants");
var _stats = require("./stats");
var _utils = require("./utils");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var replacementMap = new Map();
var globalDi = {
  getDependencies: function getDependencies(realDeps) {
    return realDeps.map(function (dep) {
      var replacedDep = replacementMap.get(dep);
      _stats.stats.track(replacedDep, dep);
      return replacedDep || dep;
    });
  },
  use: function use(deps) {
    if (replacementMap.size) {
      throw new Error("".concat(_constants.PACKAGE_NAME, " has replacements configured already. ") + "Implicit merging is not supported, so please concatenate injectables. " + "If this is not expected, please file a bug report");
    }
    deps.forEach(function (d) {
      (0, _utils.assertValidInjectable)(d);
      if (d[_constants.KEY].track) _stats.stats.set(d);
      replacementMap.set(d[_constants.KEY].from, d);
    });
  },
  clear: function clear() {
    replacementMap.clear();
  }
};
exports.globalDi = globalDi;
function runWithDi(thunk, deps) {
  globalDi.use(deps);
  var result;
  try {
    result = thunk();
    return result;
  } finally {
    // autocleanup dependences if either async or sync
    if (result && _typeof(result) === 'object' && typeof result.then === 'function' && typeof result["finally"] === 'function') {
      result["finally"](globalDi.clear);
    } else {
      globalDi.clear();
    }
  }
}