"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiProvider = void 0;
exports.withDi = withDi;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _constants = require("./constants");
var _context = require("./context");
var _stats = require("./stats");
var _utils = require("./utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
var DiProvider = function DiProvider(_ref) {
  var children = _ref.children,
    use = _ref.use,
    target = _ref.target;
  var _useContext = (0, _react.useContext)(_context.Context),
    _getDependencies = _useContext.getDependencies;

  // memo provider value so gets computed only once
  var value = (0, _react.useMemo)(function () {
    // create a map of dependency real -> replacement for fast lookup
    var replacementMap = use.reduce(function (m, d) {
      (0, _utils.assertValidInjectable)(d);
      if (d[_constants.KEY].track) _stats.stats.set(d);
      return m.set(d[_constants.KEY].from, d);
    }, new Map());
    // support single or multiple targets
    var targets = target && (Array.isArray(target) ? target : [target]);
    return {
      getDependencies: function getDependencies(realDeps, targetChild) {
        // First we collect dependencies from parent provider(s) (if any)
        var dependencies = _getDependencies(realDeps, targetChild);
        // If no target or target is in the array of targets, map use
        if (!targetChild || !targets || targets.includes(targetChild)) {
          return dependencies.map(function (dep) {
            var _dep$KEY;
            // dep can be either the original or a replacement
            // if another provider at the top has already swapped it
            // so we check if here we need to inject a different one
            // or return the original / parent replacement
            var real = ((_dep$KEY = dep[_constants.KEY]) === null || _dep$KEY === void 0 ? void 0 : _dep$KEY.from) || dep;
            var replacedDep = replacementMap.get(real);
            _stats.stats.track(replacedDep, dep);
            return replacedDep || dep;
          });
        }
        return dependencies;
      }
    };
  }, [_getDependencies]); // ignore use & target props

  return /*#__PURE__*/_react["default"].createElement(_context.Context.Provider, {
    value: value
  }, children);
};
exports.DiProvider = DiProvider;
DiProvider.propTypes = {
  children: _propTypes["default"].oneOfType([_propTypes["default"].func, _propTypes["default"].node]),
  target: _propTypes["default"].oneOfType([_propTypes["default"].func, _propTypes["default"].arrayOf(_propTypes["default"].func)]),
  use: _propTypes["default"].arrayOf(_propTypes["default"].oneOfType([_propTypes["default"].func, _propTypes["default"].object])).isRequired
};
function withDi(Comp, deps) {
  var target = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  var WrappedComponent = /*#__PURE__*/(0, _react.forwardRef)(function (props, ref) {
    return /*#__PURE__*/_react["default"].createElement(DiProvider, {
      use: deps,
      target: target
    }, /*#__PURE__*/_react["default"].createElement(Comp, _extends({
      ref: ref
    }, props)));
  });
  WrappedComponent.displayName = (0, _utils.getDisplayName)(Comp, 'withDi');
  return WrappedComponent;
}