"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assertValidInjectable = assertValidInjectable;
exports.getDisplayName = getDisplayName;
exports.injectable = injectable;
exports.mock = void 0;
exports.warnOnce = warnOnce;
var _constants = require("./constants");
var hasWarned = false;
function warnOnce(message) {
  if (!hasWarned) {
    // eslint-disable-next-line no-console
    console.error('Warning:', message);
    hasWarned = true;
  }
}
function assertValidInjectable(dep) {
  if (!dep[_constants.KEY]) throw new Error("Seems like you are trying to use \"".concat(dep, "\" as injectable, but magnetic-di needs the return value of \"injectable()\""));
}
function getDisplayName(Comp) {
  var wrapper = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  var name = Comp.displayName || Comp.name;
  return !name || !wrapper ? name : "".concat(wrapper, "(").concat(name, ")");
}
function injectable(from, implementation) {
  var _implementation$KEY, _implementation$KEY2;
  var _ref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
    displayName = _ref.displayName,
    _ref$track = _ref.track,
    track = _ref$track === void 0 ? true : _ref$track;
  implementation.displayName = displayName || getDisplayName(implementation) || getDisplayName(from, 'di');
  if ((_implementation$KEY = implementation[_constants.KEY]) !== null && _implementation$KEY !== void 0 && _implementation$KEY.from && ((_implementation$KEY2 = implementation[_constants.KEY]) === null || _implementation$KEY2 === void 0 ? void 0 : _implementation$KEY2.from) !== from) {
    warnOnce("You are trying to use replacement \"".concat(implementation.displayName, "\" on multiple injectables. ") + "That will override only the last dependency, as each replacement is uniquely linked.");
  }
  Object.defineProperty(implementation, _constants.KEY, {
    writable: true,
    // ideally this should be false, but sometimes devs reuse mocks
    value: {
      from: from,
      track: track,
      cause: new Error('Injectable created but not used. If this is on purpose, add "{track: false}"')
    }
  });
  return implementation;
}

/** @deprecated use injectable instead */
var mock = injectable;
exports.mock = mock;