function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext, useMemo, forwardRef } from 'react';
import PropTypes from 'prop-types';
import { KEY } from './constants';
import { Context } from './context';
import { stats } from './stats';
import { assertValidInjectable, getDisplayName } from './utils';
export const DiProvider = _ref => {
  let {
    children,
    use,
    target
  } = _ref;
  const {
    getDependencies
  } = useContext(Context);

  // memo provider value so gets computed only once
  const value = useMemo(() => {
    // create a map of dependency real -> replacement for fast lookup
    const replacementMap = use.reduce((m, d) => {
      assertValidInjectable(d);
      if (d[KEY].track) stats.set(d);
      return m.set(d[KEY].from, d);
    }, new Map());
    // support single or multiple targets
    const targets = target && (Array.isArray(target) ? target : [target]);
    return {
      getDependencies(realDeps, targetChild) {
        // First we collect dependencies from parent provider(s) (if any)
        const dependencies = getDependencies(realDeps, targetChild);
        // If no target or target is in the array of targets, map use
        if (!targetChild || !targets || targets.includes(targetChild)) {
          return dependencies.map(dep => {
            var _dep$KEY;
            // dep can be either the original or a replacement
            // if another provider at the top has already swapped it
            // so we check if here we need to inject a different one
            // or return the original / parent replacement
            const real = ((_dep$KEY = dep[KEY]) == null ? void 0 : _dep$KEY.from) || dep;
            const replacedDep = replacementMap.get(real);
            stats.track(replacedDep, dep);
            return replacedDep || dep;
          });
        }
        return dependencies;
      }
    };
  }, [getDependencies]); // ignore use & target props

  return /*#__PURE__*/React.createElement(Context.Provider, {
    value: value
  }, children);
};
DiProvider.propTypes = {
  children: PropTypes.oneOfType([PropTypes.func, PropTypes.node]),
  target: PropTypes.oneOfType([PropTypes.func, PropTypes.arrayOf(PropTypes.func)]),
  use: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object])).isRequired
};
export function withDi(Comp, deps, target) {
  if (target === void 0) {
    target = null;
  }
  const WrappedComponent = /*#__PURE__*/forwardRef((props, ref) => /*#__PURE__*/React.createElement(DiProvider, {
    use: deps,
    target: target
  }, /*#__PURE__*/React.createElement(Comp, _extends({
    ref: ref
  }, props))));
  WrappedComponent.displayName = getDisplayName(Comp, 'withDi');
  return WrappedComponent;
}