import { KEY } from './constants';
let hasWarned = false;
export function warnOnce(message) {
  if (!hasWarned) {
    // eslint-disable-next-line no-console
    console.error('Warning:', message);
    hasWarned = true;
  }
}
export function assertValidInjectable(dep) {
  if (!dep[KEY]) throw new Error(`Seems like you are trying to use "${dep}" as injectable, but magnetic-di needs the return value of "injectable()"`);
}
export function getDisplayName(Comp, wrapper) {
  if (wrapper === void 0) {
    wrapper = '';
  }
  const name = Comp.displayName || Comp.name;
  return !name || !wrapper ? name : `${wrapper}(${name})`;
}
export function injectable(from, implementation, _temp) {
  var _implementation$KEY, _implementation$KEY2;
  let {
    displayName,
    track = true
  } = _temp === void 0 ? {} : _temp;
  implementation.displayName = displayName || getDisplayName(implementation) || getDisplayName(from, 'di');
  if ((_implementation$KEY = implementation[KEY]) != null && _implementation$KEY.from && ((_implementation$KEY2 = implementation[KEY]) == null ? void 0 : _implementation$KEY2.from) !== from) {
    warnOnce(`You are trying to use replacement "${implementation.displayName}" on multiple injectables. ` + `That will override only the last dependency, as each replacement is uniquely linked.`);
  }
  Object.defineProperty(implementation, KEY, {
    writable: true,
    // ideally this should be false, but sometimes devs reuse mocks
    value: {
      from,
      track,
      cause: new Error('Injectable created but not used. If this is on purpose, add "{track: false}"')
    }
  });
  return implementation;
}

/** @deprecated use injectable instead */
export const mock = injectable;