'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _desc, _value, _class, _class2, _temp; // Copyright (c) 2015 Uber Technologies, Inc.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Portions of the code below originally from:
// https://github.com/mapbox/mapbox-gl-js/blob/master/js/ui/handler/scroll_zoom.js


var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _autobindDecorator = require('autobind-decorator');

var _autobindDecorator2 = _interopRequireDefault(_autobindDecorator);

var _document = require('global/document');

var _document2 = _interopRequireDefault(_document);

var _window = require('global/window');

var _window2 = _interopRequireDefault(_window);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

function noop() {}

var ua = typeof _window2.default.navigator !== 'undefined' ? _window2.default.navigator.userAgent.toLowerCase() : '';
var firefox = ua.indexOf('firefox') !== -1;

// Extract a position from a mouse event
function getMousePosition(el, event) {
  var rect = el.getBoundingClientRect();
  event = event.touches ? event.touches[0] : event;
  return [event.clientX - rect.left - el.clientLeft, event.clientY - rect.top - el.clientTop];
}

// Extract an array of touch positions from a touch event
function getTouchPositions(el, event) {
  var points = [];
  var rect = el.getBoundingClientRect();
  var touches = getTouches(event);
  for (var i = 0; i < touches.length; i++) {
    points.push([touches[i].clientX - rect.left - el.clientLeft, touches[i].clientY - rect.top - el.clientTop]);
  }
  return points;
}

// Get relevant touches from event depending on event type (for `touchend` and
// `touchcancel` the property `changedTouches` contains the relevant coordinates)
function getTouches(event) {
  var type = event.type;
  if (type === 'touchend' || type === 'touchcancel') {
    return event.changedTouches;
  }
  return event.touches;
}

// Return the centroid of an array of points
function centroid(positions) {
  var sum = positions.reduce(function (acc, elt) {
    return [acc[0] + elt[0], acc[1] + elt[1]];
  }, [0, 0]);
  return [sum[0] / positions.length, sum[1] / positions.length];
}

var Interactions = (_class = (_temp = _class2 = function (_Component) {
  _inherits(Interactions, _Component);

  function Interactions(props) {
    _classCallCheck(this, Interactions);

    var _this = _possibleConstructorReturn(this, (Interactions.__proto__ || Object.getPrototypeOf(Interactions)).call(this, props));

    _this.state = {
      didDrag: false,
      isFunctionKeyPressed: false,
      startPos: null,
      pos: null,
      mouseWheelPos: null
    };
    return _this;
  }

  _createClass(Interactions, [{
    key: '_getMousePos',
    value: function _getMousePos(event) {
      var el = this.refs.container;
      return getMousePosition(el, event);
    }
  }, {
    key: '_getTouchPos',
    value: function _getTouchPos(event) {
      var el = this.refs.container;
      var positions = getTouchPositions(el, event);
      return centroid(positions);
    }
  }, {
    key: '_isFunctionKeyPressed',
    value: function _isFunctionKeyPressed(event) {
      return Boolean(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey);
    }
  }, {
    key: '_onMouseDown',
    value: function _onMouseDown(event) {
      var pos = this._getMousePos(event);
      this.setState({
        didDrag: false,
        startPos: pos,
        pos: pos,
        isFunctionKeyPressed: this._isFunctionKeyPressed(event)
      });
      this.props.onMouseDown({ pos: pos });
      _document2.default.addEventListener('mousemove', this._onMouseDrag, false);
      _document2.default.addEventListener('mouseup', this._onMouseUp, false);
    }
  }, {
    key: '_onTouchStart',
    value: function _onTouchStart(event) {
      var pos = this._getTouchPos(event);
      this.setState({
        didDrag: false,
        startPos: pos,
        pos: pos,
        isFunctionKeyPressed: this._isFunctionKeyPressed(event)
      });
      this.props.onTouchStart({ pos: pos });
      _document2.default.addEventListener('touchmove', this._onTouchDrag, false);
      _document2.default.addEventListener('touchend', this._onTouchEnd, false);
    }
  }, {
    key: '_onMouseDrag',
    value: function _onMouseDrag(event) {
      var pos = this._getMousePos(event);
      this.setState({ pos: pos, didDrag: true });
      if (this.state.isFunctionKeyPressed) {
        var startPos = this.state.startPos;

        this.props.onMouseRotate({ pos: pos, startPos: startPos });
      } else {
        this.props.onMouseDrag({ pos: pos });
      }
    }
  }, {
    key: '_onTouchDrag',
    value: function _onTouchDrag(event) {
      var pos = this._getTouchPos(event);
      this.setState({ pos: pos, didDrag: true });
      if (this.state.isFunctionKeyPressed) {
        var startPos = this.state.startPos;

        this.props.onTouchRotate({ pos: pos, startPos: startPos });
      } else {
        this.props.onTouchDrag({ pos: pos });
      }
      event.preventDefault();
    }
  }, {
    key: '_onMouseUp',
    value: function _onMouseUp(event) {
      _document2.default.removeEventListener('mousemove', this._onMouseDrag, false);
      _document2.default.removeEventListener('mouseup', this._onMouseUp, false);
      var pos = this._getMousePos(event);
      this.setState({ pos: pos });
      this.props.onMouseUp({ pos: pos });
      if (!this.state.didDrag) {
        this.props.onMouseClick({ pos: pos });
      }
    }
  }, {
    key: '_onTouchEnd',
    value: function _onTouchEnd(event) {
      _document2.default.removeEventListener('touchmove', this._onTouchDrag, false);
      _document2.default.removeEventListener('touchend', this._onTouchEnd, false);
      var pos = this._getTouchPos(event);
      this.setState({ pos: pos });
      this.props.onTouchEnd({ pos: pos });
      if (!this.state.didDrag) {
        this.props.onTouchTap({ pos: pos });
      }
    }
  }, {
    key: '_onMouseMove',
    value: function _onMouseMove(event) {
      var pos = this._getMousePos(event);
      this.props.onMouseMove({ pos: pos });
    }

    /* eslint-disable complexity, max-statements */

  }, {
    key: '_onWheel',
    value: function _onWheel(event) {
      // Exit if scroll zoom isn't enabled
      if (!this.props.scrollZoomEnabled) {
        return;
      }
      event.preventDefault();
      var value = event.deltaY;
      // Firefox doubles the values on retina screens...
      if (firefox && event.deltaMode === _window2.default.WheelEvent.DOM_DELTA_PIXEL) {
        value /= _window2.default.devicePixelRatio;
      }
      if (event.deltaMode === _window2.default.WheelEvent.DOM_DELTA_LINE) {
        value *= 40;
      }

      var type = this.state.mouseWheelType;
      var timeout = this.state.mouseWheelTimeout;
      var lastValue = this.state.mouseWheelLastValue;
      var time = this.state.mouseWheelTime;

      var now = (_window2.default.performance || Date).now();
      var timeDelta = now - (time || 0);

      var pos = this._getMousePos(event);
      time = now;

      if (value !== 0 && value % 4.000244140625 === 0) {
        // This one is definitely a mouse wheel event.
        type = 'wheel';
        // Normalize this value to match trackpad.
        value = Math.floor(value / 4);
      } else if (value !== 0 && Math.abs(value) < 4) {
        // This one is definitely a trackpad event because it is so small.
        type = 'trackpad';
      } else if (timeDelta > 400) {
        // This is likely a new scroll action.
        type = null;
        lastValue = value;

        // Start a timeout in case this was a singular event, and delay it by up
        // to 40ms.
        timeout = _window2.default.setTimeout(function setTimeout() {
          var _type = 'wheel';
          this._zoom(-this.state.mouseWheelLastValue, this.state.mouseWheelPos);
          this.setState({ mouseWheelType: _type });
        }.bind(this), 40);
      } else if (!this._type) {
        // This is a repeating event, but we don't know the type of event just
        // yet.
        // If the delta per time is small, we assume it's a fast trackpad;
        // otherwise we switch into wheel mode.
        type = Math.abs(timeDelta * value) < 200 ? 'trackpad' : 'wheel';

        // Make sure our delayed event isn't fired again, because we accumulate
        // the previous event (which was less than 40ms ago) into this event.
        if (timeout) {
          _window2.default.clearTimeout(timeout);
          timeout = null;
          value += lastValue;
        }
      }

      // Slow down zoom if shift key is held for more precise zooming
      if (event.shiftKey && value) {
        value = value / 4;
      }

      // Only fire the callback if we actually know what type of scrolling device
      // the user uses.
      if (type) {
        this._zoom(-value, pos);
      }

      this.setState({
        mouseWheelTime: time,
        mouseWheelPos: pos,
        mouseWheelType: type,
        mouseWheelTimeout: timeout,
        mouseWheelLastValue: lastValue
      });
    }
    /* eslint-enable complexity, max-statements */

  }, {
    key: '_zoom',
    value: function _zoom(delta, pos) {
      // Scale by sigmoid of scroll wheel delta.
      var scale = 2 / (1 + Math.exp(-Math.abs(delta / 100)));
      if (delta < 0 && scale !== 0) {
        scale = 1 / scale;
      }
      this.props.onZoom({ pos: pos, scale: scale });
      _window2.default.clearTimeout(this._zoomEndTimeout);
      this._zoomEndTimeout = _window2.default.setTimeout(function _setTimeout() {
        this.props.onZoomEnd();
      }.bind(this), 200);
    }
  }, {
    key: 'render',
    value: function render() {
      return _react2.default.createElement(
        'div',
        {
          ref: 'container',
          onMouseMove: this._onMouseMove,
          onMouseDown: this._onMouseDown,
          onTouchStart: this._onTouchStart,
          onContextMenu: this._onMouseDown,
          onWheel: this._onWheel,
          style: {
            width: this.props.width,
            height: this.props.height,
            position: 'relative'
          } },
        this.props.children
      );
    }
  }]);

  return Interactions;
}(_react.Component), _class2.displayName = 'Interactions', _class2.propTypes = {
  width: _react.PropTypes.number.isRequired,
  height: _react.PropTypes.number.isRequired,
  onMouseDown: _react.PropTypes.func,
  onMouseDrag: _react.PropTypes.func,
  onMouseRotate: _react.PropTypes.func,
  onMouseUp: _react.PropTypes.func,
  onMouseMove: _react.PropTypes.func,
  onMouseClick: _react.PropTypes.func,
  onTouchStart: _react.PropTypes.func,
  onTouchDrag: _react.PropTypes.func,
  onTouchRotate: _react.PropTypes.func,
  onTouchEnd: _react.PropTypes.func,
  onTouchTap: _react.PropTypes.func,
  onZoom: _react.PropTypes.func,
  onZoomEnd: _react.PropTypes.func,
  scrollZoomEnabled: _react.PropTypes.bool
}, _class2.defaultProps = {
  onMouseDown: noop,
  onMouseDrag: noop,
  onMouseRotate: noop,
  onMouseUp: noop,
  onMouseMove: noop,
  onMouseClick: noop,
  onTouchStart: noop,
  onTouchDrag: noop,
  onTouchRotate: noop,
  onTouchEnd: noop,
  onTouchTap: noop,
  onZoom: noop,
  onZoomEnd: noop,
  scrollZoomEnabled: true
}, _temp), (_applyDecoratedDescriptor(_class.prototype, '_onMouseDown', [_autobindDecorator2.default], Object.getOwnPropertyDescriptor(_class.prototype, '_onMouseDown'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, '_onTouchStart', [_autobindDecorator2.default], Object.getOwnPropertyDescriptor(_class.prototype, '_onTouchStart'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, '_onMouseDrag', [_autobindDecorator2.default], Object.getOwnPropertyDescriptor(_class.prototype, '_onMouseDrag'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, '_onTouchDrag', [_autobindDecorator2.default], Object.getOwnPropertyDescriptor(_class.prototype, '_onTouchDrag'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, '_onMouseUp', [_autobindDecorator2.default], Object.getOwnPropertyDescriptor(_class.prototype, '_onMouseUp'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, '_onTouchEnd', [_autobindDecorator2.default], Object.getOwnPropertyDescriptor(_class.prototype, '_onTouchEnd'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, '_onMouseMove', [_autobindDecorator2.default], Object.getOwnPropertyDescriptor(_class.prototype, '_onMouseMove'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, '_onWheel', [_autobindDecorator2.default], Object.getOwnPropertyDescriptor(_class.prototype, '_onWheel'), _class.prototype)), _class);
exports.default = Interactions;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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