'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _Icon = require('./Icon');

var _Icon2 = _interopRequireDefault(_Icon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Card = function (_React$Component) {
  _inherits(Card, _React$Component);

  function Card(props) {
    _classCallCheck(this, Card);

    var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(Card).call(this, props));

    _this.renderTitle = _this.renderTitle.bind(_this);
    return _this;
  }

  _createClass(Card, [{
    key: 'render',
    value: function render() {
      var _props = this.props;
      var title = _props.title;
      var header = _props.header;
      var className = _props.className;
      var textClassName = _props.textClassName;
      var actions = _props.actions;
      var reveal = _props.reveal;
      var children = _props.children;

      var props = _objectWithoutProperties(_props, ['title', 'header', 'className', 'textClassName', 'actions', 'reveal', 'children']);

      var classes = { card: true };
      return _react2.default.createElement(
        'div',
        _extends({}, props, {
          className: (0, _classnames2.default)(className, classes) }),
        header,
        _react2.default.createElement(
          'div',
          { className: (0, _classnames2.default)('card-content', textClassName) },
          title ? this.renderTitle(title, reveal) : null,
          _react2.default.createElement(
            'div',
            null,
            children
          )
        ),
        this.renderReveal(title, reveal),
        actions ? this.renderAction(actions) : null
      );
    }
  }, {
    key: 'renderTitle',
    value: function renderTitle(title, reveal) {
      var revealIcon = null;
      if (reveal) {
        revealIcon = _react2.default.createElement(
          _Icon2.default,
          { right: true },
          'more_vert'
        );
      }
      var classes = {
        'card-title': true,
        'grey-text': true,
        'text-darken-4': true,
        'activator': reveal
      };
      return _react2.default.createElement(
        'span',
        { className: (0, _classnames2.default)(classes) },
        title,
        revealIcon
      );
    }
  }, {
    key: 'renderReveal',
    value: function renderReveal(title, reveal) {
      return _react2.default.createElement(
        'div',
        { className: 'card-reveal' },
        _react2.default.createElement(
          'span',
          { className: 'card-title grey-text text-darken-4' },
          title,
          _react2.default.createElement(
            _Icon2.default,
            { right: true },
            'close'
          )
        ),
        reveal
      );
    }
  }, {
    key: 'renderAction',
    value: function renderAction(actions) {
      return _react2.default.createElement(
        'div',
        { className: 'card-action' },
        ' ',
        actions,
        ' '
      );
    }
  }]);

  return Card;
}(_react2.default.Component);

Card.propTypes = {
  title: _react2.default.PropTypes.string,
  textClassName: _react2.default.PropTypes.string,
  reveal: _react2.default.PropTypes.element,
  header: _react2.default.PropTypes.element,
  // The buttons to be displayed at the action area
  actions: _react2.default.PropTypes.arrayOf(_react2.default.PropTypes.element)
};

exports.default = Card;