'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _constants = require('./constants');

var _constants2 = _interopRequireDefault(_constants);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var CardTitle = function (_React$Component) {
  _inherits(CardTitle, _React$Component);

  function CardTitle() {
    _classCallCheck(this, CardTitle);

    return _possibleConstructorReturn(this, Object.getPrototypeOf(CardTitle).apply(this, arguments));
  }

  _createClass(CardTitle, [{
    key: 'render',
    value: function render() {
      var _props = this.props;
      var image = _props.image;
      var reveal = _props.reveal;
      var waves = _props.waves;
      var children = _props.children;

      var props = _objectWithoutProperties(_props, ['image', 'reveal', 'waves', 'children']);

      var classes = {
        'card-image': true
      };
      if (waves) {
        classes['waves-effect'] = true, classes['waves-' + waves] = true, classes['waves-block'] = true;
      }
      var imgClasses = { 'activator': reveal };
      var titleClasses = {
        'card-title': true
      };
      return _react2.default.createElement(
        'div',
        _extends({ className: (0, _classnames2.default)(classes) }, props),
        _react2.default.createElement('img', { className: (0, _classnames2.default)(imgClasses), src: image }),
        _react2.default.createElement(
          'span',
          { className: (0, _classnames2.default)(titleClasses) },
          children
        )
      );
    }
  }]);

  return CardTitle;
}(_react2.default.Component);

CardTitle.propTypes = {
  // Whether the image serves as activator for the reveal
  reveal: _react2.default.PropTypes.bool,
  // the waves effect
  waves: _react2.default.PropTypes.oneOf(_constants2.default.WAVES),
  // The path to the image
  image: _react2.default.PropTypes.string.isRequired
};

exports.default = CardTitle;