'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _constants = require('./constants');

var _constants2 = _interopRequireDefault(_constants);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Slide = function (_React$Component) {
  _inherits(Slide, _React$Component);

  function Slide(props) {
    _classCallCheck(this, Slide);

    var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(Slide).call(this, props));

    _this.renderCaption = _this.renderCaption.bind(_this);
    return _this;
  }

  _createClass(Slide, [{
    key: 'render',
    value: function render() {
      return _react2.default.createElement(
        'li',
        null,
        _react2.default.createElement('img', { src: this.props.src }),
        this.renderCaption()
      );
    }
  }, {
    key: 'renderCaption',
    value: function renderCaption() {
      var _props = this.props;
      var title = _props.title;
      var className = _props.className;
      var alignment = _props.alignment;
      var children = _props.children;

      var props = _objectWithoutProperties(_props, ['title', 'className', 'alignment', 'children']);

      var classes = {
        caption: true
      };
      classes[alignment + '-align'] = true;

      if (typeof title !== 'undefined' || typeof children !== 'undefined') {
        return _react2.default.createElement(
          'div',
          _extends({ className: (0, _classnames2.default)(classes) }, props),
          _react2.default.createElement(
            'h3',
            null,
            title
          ),
          _react2.default.createElement(
            'h5',
            { className: className },
            children
          )
        );
      } else return null;
    }
  }]);

  return Slide;
}(_react2.default.Component);

Slide.propTypes = {
  /**
  * Aliment of the caption
  * @default 'center'
  */
  alignment: _react2.default.PropTypes.oneOf(_constants2.default.PLACEMENTS),
  /**
  * The tagline of the caption
  */
  title: _react2.default.PropTypes.string,
  /**
   * The path of the background image
   */
  src: _react2.default.PropTypes.string.isRequired
};

Slide.defaultProps = {
  placement: 'center'
};

exports.default = Slide;