'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _resizeObserverPolyfill = require('resize-observer-polyfill');

var _resizeObserverPolyfill2 = _interopRequireDefault(_resizeObserverPolyfill);

var _utils = require('./utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Measure = function (_Component) {
  _inherits(Measure, _Component);

  function Measure() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, Measure);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Measure.__proto__ || Object.getPrototypeOf(Measure)).call.apply(_ref, [this].concat(args))), _this), _this.firstResizeEvent = true, _this.nodes = {}, _this.refsById = {}, _this.state = { measurements: null }, _this.bind = function (id) {
      if (!_this.refsById[id]) {
        _this.refsById[id] = function (node) {
          if (node) {
            _this.nodes[id] = node;
            _this.resizeObserver.observe(node);
          } else {
            _this.resizeObserver.unobserve(_this.nodes[id]);
            delete _this.nodes[id];
          }
          _this.setState(function (state) {
            var newMeasurements = _extends({}, state.measurements);
            if (node) {
              newMeasurements[id] = (0, _utils.getMeasurements)(node);
            } else {
              delete newMeasurements[id];
            }
            return { measurements: newMeasurements };
          }, _this.fireOnMeasure);
        };
      }
      return { ref: _this.refsById[id] };
    }, _this.resizeObserver = new _resizeObserverPolyfill2.default(function (entries) {
      if (_this.firstResizeEvent) {
        _this.firstResizeEvent = false;
      } else {
        _this.setState(function (state) {
          var newMeasurements = _extends({}, state.measurements);
          entries.forEach(function (entry) {
            var id = _this.getIdFromNode(entry.target);
            newMeasurements[id] = (0, _utils.getMeasurements)(entry.target);
          });
          return { measurements: newMeasurements };
        }, _this.fireOnMeasure);
      }
    }), _this.getIdFromNode = function (node) {
      var id = null;
      Object.keys(_this.nodes).some(function (key) {
        if (_this.nodes[key] === node) {
          return id = key;
        }
      });
      return id;
    }, _this.fireOnMeasure = function () {
      if (_this.props.onMeasure) {
        _this.props.onMeasure(_this.state.measurements);
      }
    }, _this.measure = function () {
      _this.setState(function (state) {
        var newMeasurements = _extends({}, state.measurements);
        Object.keys(_this.nodes).some(function (key) {
          newMeasurements[key] = (0, _utils.getMeasurements)(_this.nodes[key]);
        });
        return { measurements: newMeasurements };
      }, _this.fireOnMeasure);
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }
  // prevent firing two renders when component mounts, getting measurements in bind
  // is faster than attaching a ResizeObserver and waiting for the first callback


  _createClass(Measure, [{
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      this.resizeObserver.disconnect();
    }
  }, {
    key: 'render',
    value: function render() {
      return this.props.children({
        bind: this.bind,
        measure: this.measure,
        measurements: this.state.measurements
      });
    }
  }]);

  return Measure;
}(_react.Component);

exports.default = Measure;