'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _resizeObserverPolyfill = require('resize-observer-polyfill');

var _resizeObserverPolyfill2 = _interopRequireDefault(_resizeObserverPolyfill);

var _utils = require('./utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Viewport = function (_Component) {
  _inherits(Viewport, _Component);

  function Viewport() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, Viewport);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Viewport.__proto__ || Object.getPrototypeOf(Viewport)).call.apply(_ref, [this].concat(args))), _this), _this.firstResizeEvent = true, _this.initialScrollX = 0, _this.initialScrollY = 0, _this.state = {
      width: 0,
      height: 0,
      scrollWidth: 0,
      scrollHeight: 0,
      scrollX: 0,
      scrollY: 0,
      scrollXDirection: null,
      scrollYDirection: null
    }, _this.requestScroll = function () {
      _this.latestScrollX = _this.isWindow ? window.pageXOffset : _this.scrollElement.scrollLeft;
      _this.latestScrollY = _this.isWindow ? window.pageYOffset : _this.scrollElement.scrollTop;
      if (!_this.isScrolling) {
        requestAnimationFrame(_this.updateScroll);
        _this.isScrolling = true;
      }
    }, _this.updateScroll = function () {
      var scrollXDirection = (0, _utils.getScrollDirection)('x', _this.lastScrollX, _this.latestScrollX);
      var scrollYDirection = (0, _utils.getScrollDirection)('y', _this.lastScrollY, _this.latestScrollY);

      _this.lastScrollX = _this.latestScrollX;
      _this.lastScrollY = _this.latestScrollY;

      _this.setState({
        scrollX: _this.latestScrollX,
        scrollY: _this.latestScrollY,
        scrollXDirection: scrollXDirection,
        scrollYDirection: scrollYDirection
      });

      _this.isScrolling = false;
    }, _this.updateWindowSize = function () {
      _this.setState((0, _utils.getWindowSize)());
    }, _this.updateElementSize = function () {
      _this.setState((0, _utils.getElementSize)(_this.scrollElement));
    }, _this.setRef = function (node) {
      if (!_this.node) {
        _this.node = node;
      }
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(Viewport, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      var _this2 = this;

      this.scrollElement = (0, _utils.getClosestScrollElement)(this.node);
      this.isWindow = this.scrollElement === window;

      this.scrollElement.addEventListener('scroll', this.requestScroll);
      this.requestScroll();

      this.initialScrollX = this.isWindow ? window.pageXOffset : this.scrollElement.scrollLeft;
      this.initialScrollY = this.isWindow ? window.pageYOffset : this.scrollElement.scrollTop;

      if (this.isWindow) {
        window.addEventListener('resize', this.updateWindowSize);
        this.updateWindowSize();
      } else {
        this.resizeObserver = new _resizeObserverPolyfill2.default(function () {
          if (_this2.firstResizeEvent) {
            _this2.firstResizeEvent = false;
          } else {
            _this2.updateElementSize();
          }
        });
        this.resizeObserver.observe(this.scrollElement);
        this.updateElementSize();
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      this.scrollElement.removeEventListener('scroll', this.requestScroll);
      if (this.isWindow) {
        window.removeEventListener('resize', this.updateWindowSize);
      } else {
        this.resizeObserver.disconnect();
      }
    }
  }, {
    key: 'render',
    value: function render() {
      return this.props.children(_extends({
        bind: {
          ref: this.setRef
        },
        initialScrollX: this.initialScrollX,
        initialScrollY: this.initialScrollY
      }, this.state));
    }
  }]);

  return Viewport;
}(_react.Component);

exports.default = Viewport;