'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isScrollElement = isScrollElement;
exports.getParentNode = getParentNode;
exports.getClosestScrollElement = getClosestScrollElement;
exports.getScrollDirection = getScrollDirection;
exports.getDocumentWidth = getDocumentWidth;
exports.getDocumentHeight = getDocumentHeight;
exports.getWindowSize = getWindowSize;
exports.getElementSize = getElementSize;
exports.getMeasurements = getMeasurements;
var body = document.body;
var html = document.documentElement;

function isScrollElement(element) {
  try {
    var _window$getComputedSt = window.getComputedStyle(element),
        overflow = _window$getComputedSt.overflow,
        overflowX = _window$getComputedSt.overflowX,
        overflowY = _window$getComputedSt.overflowY;

    return (/(auto|scroll)/.test(overflow + overflowX + overflowY)
    );
  } catch (e) {
    return false;
  }
}

function getParentNode(element) {
  if (element.nodeName === 'HTML') {
    return element;
  }
  return element.parentNode || element.host;
}

function getClosestScrollElement(element) {
  if (!element || element === body) {
    return window;
  } else if (isScrollElement(element)) {
    return element;
  } else {
    return getClosestScrollElement(getParentNode(element));
  }
}

function getScrollDirection(axis, last, next) {
  if (next === last) {
    return null;
  } else {
    return next - last > 0 ? axis === 'x' ? 'right' : 'down' : axis === 'x' ? 'left' : 'up';
  }
}

function getDocumentWidth() {
  return Math.max(body.scrollWidth, body.offsetWidth, html.clientWidth, html.scrollWidth, html.offsetWidth);
}

function getDocumentHeight() {
  return Math.max(body.scrollHeight, body.offsetHeight, html.clientHeight, html.scrollHeight, html.offsetHeight);
}

function getWindowSize() {
  return {
    width: window.innerWidth,
    height: window.innerHeight,
    scrollWidth: getDocumentWidth(),
    scrollHeight: getDocumentHeight()
  };
}

function getElementSize(node) {
  return {
    width: node.offsetWidth,
    height: node.offsetHeight,
    scrollWidth: node.scrollWidth,
    scrollHeight: node.scrollHeight
  };
}

function getMeasurements(node) {
  var rect = node.getBoundingClientRect();
  return {
    x: rect.x,
    y: rect.y,
    width: rect.width,
    height: rect.height,
    top: rect.top,
    right: rect.right,
    bottom: rect.bottom,
    left: rect.left,
    offsetWidth: node.offsetWidth,
    offsetHeight: node.offsetHeight,
    scrollTop: node.scrollTop,
    scrollLeft: node.scrollLeft,
    scrollWidth: node.scrollWidth,
    scrollHeight: node.scrollHeight
  };
}