import { Renderer, SnappableProps, SnappableState, ScalableProps, RotatableProps, RectInfo, MoveableManagerInterface, MoveableGroupInterface } from "../types";
export interface SnapPoses {
    vertical: number[];
    horizontal: number[];
}
export declare function snapStart(moveable: MoveableManagerInterface<SnappableProps, SnappableState>): void;
export declare function normalized(value: number): number;
export declare function getSizeOffsetInfo(moveable: MoveableManagerInterface<SnappableProps, SnappableState>, poses: number[][], direction: number[], keepRatio: boolean, isRequest: boolean, datas: any): {
    width: {
        isBound: boolean;
        offset: number;
    };
    height: {
        isBound: boolean;
        offset: number;
    };
};
export declare function recheckSizeByTwoDirection(moveable: MoveableManagerInterface<SnappableProps, SnappableState>, poses: number[][], width: number, height: number, maxWidth: number, maxHeight: number, direction: number[], isRequest: boolean, datas: any): number[];
export declare function checkSizeDist(moveable: MoveableManagerInterface<any, any>, getNextPoses: (widthOffset: number, heightOffset: number) => number[][], width: number, height: number, direction: number[], fixedPosition: number[], isRequest: boolean, datas: any): number[];
export declare function checkSnapRotate(moveable: MoveableManagerInterface<SnappableProps & RotatableProps, any>, rect: RectInfo, origin: number[], rotation: number): number;
export declare function checkSnapResize(moveable: MoveableManagerInterface<{}, {}>, width: number, height: number, direction: number[], fixedPosition: number[], isRequest: boolean, datas: any): number[];
export declare function checkSnapScale(moveable: MoveableManagerInterface<ScalableProps, any>, scale: number[], direction: number[], isRequest: boolean, datas: any): number[];
export declare function startCheckSnapDrag(moveable: MoveableManagerInterface<any, any>, datas: any): void;
declare const _default: {
    name: string;
    props: {
        readonly snappable: readonly [BooleanConstructor, ArrayConstructor];
        readonly snapContainer: ObjectConstructor;
        readonly snapDirections: readonly [BooleanConstructor, ObjectConstructor];
        readonly elementSnapDirections: readonly [BooleanConstructor, ObjectConstructor];
        readonly snapGap: BooleanConstructor;
        readonly snapGridWidth: NumberConstructor;
        readonly snapGridHeight: NumberConstructor;
        readonly isDisplaySnapDigit: BooleanConstructor;
        readonly isDisplayInnerSnapDigit: BooleanConstructor;
        readonly snapDigit: NumberConstructor;
        readonly snapThreshold: NumberConstructor;
        readonly horizontalGuidelines: ArrayConstructor;
        readonly verticalGuidelines: ArrayConstructor;
        readonly elementGuidelines: ArrayConstructor;
        readonly bounds: ObjectConstructor;
        readonly innerBounds: ObjectConstructor;
        readonly snapDistFormat: FunctionConstructor;
    };
    events: {
        readonly onSnap: "snap";
    };
    css: string[];
    render(moveable: MoveableManagerInterface<SnappableProps, SnappableState>, React: Renderer): any[];
    dragStart(moveable: MoveableManagerInterface<SnappableProps, SnappableState>, e: any): void;
    drag(moveable: MoveableManagerInterface<SnappableProps, SnappableState>): void;
    pinchStart(moveable: MoveableManagerInterface<SnappableProps, SnappableState>): void;
    dragEnd(moveable: MoveableManagerInterface<SnappableProps, SnappableState>): void;
    dragControlCondition(moveable: MoveableManagerInterface, e: any): boolean | undefined;
    dragControlStart(moveable: MoveableManagerInterface<SnappableProps, SnappableState>): void;
    dragControl(moveable: MoveableManagerInterface<SnappableProps, SnappableState>): void;
    dragControlEnd(moveable: MoveableManagerInterface<SnappableProps, SnappableState>): void;
    dragGroupStart(moveable: any, e: any): void;
    dragGroup(moveable: MoveableGroupInterface<SnappableProps, SnappableState>): void;
    dragGroupEnd(moveable: MoveableGroupInterface<SnappableProps, SnappableState>): void;
    dragGroupControlStart(moveable: MoveableGroupInterface<SnappableProps, SnappableState>): void;
    dragGroupControl(moveable: MoveableManagerInterface<SnappableProps, SnappableState>): void;
    dragGroupControlEnd(moveable: MoveableGroupInterface<SnappableProps, SnappableState>): void;
    unset(moveable: any): void;
};
export default _default;
