import MoveableManager from "./MoveableManager";
import { GroupableProps, MoveableManagerProps, RectInfo } from "./types";
import ChildrenDiffer from "@egjs/children-differ";
declare class MoveableGroup extends MoveableManager<GroupableProps> {
    static defaultProps: {
        transformOrigin: string[];
        groupable: boolean;
        dragArea: boolean;
        keepRatio: boolean;
        targets: never[];
        defaultGroupRotate: number;
        defaultGroupOrigin: string;
        cssStyled: any;
        customStyledMap: Record<string, any>;
        wrapperMoveable: import("./types").MoveableManagerInterface<{}, {}> | null;
        parentMoveable: import("./types").MoveableManagerInterface<{}, {}> | null;
        parentPosition: {
            left: number;
            top: number;
        } | null;
        target: SVGElement | HTMLElement | null;
        dragTarget: SVGElement | HTMLElement | null;
        container: SVGElement | HTMLElement | null;
        portalContainer: HTMLElement | null;
        rootContainer: HTMLElement | null;
        zoom: number;
        edge: boolean;
        ables: import("./types").Able<import("@daybrush/utils").IObject<any>, import("@daybrush/utils").IObject<any>>[];
        className: string;
        pinchThreshold: number;
        pinchOutside: boolean;
        triggerAblesSimultaneously: boolean;
        checkInput: boolean;
        cspNonce: string;
        translateZ: string | number;
        hideDefaultLines: boolean;
        props: Record<string, any>;
        passDragArea: boolean;
        origin: boolean;
        padding: import("./types").PaddingBox;
    };
    differ: ChildrenDiffer<HTMLElement | SVGElement>;
    moveables: MoveableManager[];
    transformOrigin: string;
    updateEvent(prevProps: MoveableManagerProps<GroupableProps>): void;
    checkUpdate(): void;
    updateRect(type?: "Start" | "" | "End", isTarget?: boolean, isSetState?: boolean): void;
    getRect(): RectInfo;
    triggerEvent(name: string, e: any, isManager?: boolean): any;
    protected updateAbles(): void;
}
export default MoveableGroup;
