import * as React from "react";
import Gesto from "gesto";
import { MoveableManagerProps, MoveableManagerState, Able, RectInfo, Requester, HitRect, MoveableManagerInterface } from "./types";
import { IObject } from "@daybrush/utils";
import EventManager from "./EventManager";
export default class MoveableManager<T = {}> extends React.PureComponent<MoveableManagerProps<T>, MoveableManagerState> {
    static defaultProps: Required<MoveableManagerProps>;
    state: MoveableManagerState;
    enabledAbles: Able[];
    targetAbles: Able[];
    controlAbles: Able[];
    controlBox: {
        getElement(): HTMLElement;
    };
    areaElement: HTMLElement;
    targetGesto: Gesto;
    controlGesto: Gesto;
    rotation: number;
    scale: number[];
    isUnmounted: boolean;
    events: Record<string, EventManager | null>;
    private _prevTarget;
    private _prevDragArea;
    render(): JSX.Element;
    componentDidMount(): void;
    componentDidUpdate(): void;
    componentWillUnmount(): void;
    getContainer(): HTMLElement | SVGElement;
    isMoveableElement(target: Element): boolean;
    dragStart(e: MouseEvent | TouchEvent): this;
    hitTest(el: Element | HitRect): number;
    isInside(clientX: number, clientY: number): boolean;
    updateRect(type?: "Start" | "" | "End", isTarget?: boolean, isSetState?: boolean): void;
    isDragging(): boolean;
    updateTarget(type?: "Start" | "" | "End"): void;
    getRect(): RectInfo;
    getManager(): MoveableManagerInterface<any, any>;
    getRotation(): number;
    request(ableName: string, param?: IObject<any>, isInstant?: boolean): Requester;
    destroy(): void;
    updateRenderPoses(): void;
    checkUpdate(): void;
    triggerEvent(name: string, e: any): any;
    useCSS(tag: string, css: string): any;
    onPreventClick: (e: any) => void;
    protected unsetAbles(): void;
    protected updateAbles(ables?: Able[], eventAffix?: string): void;
    protected updateState(nextState: any, isSetState?: boolean): void;
    protected getEnabledAbles(): Able<IObject<any>, IObject<any>>[];
    protected renderAbles(): any[];
    protected updateCheckInput(): void;
    private _renderLines;
    private _updateTargets;
    private _isTargetChanged;
    private _updateEvents;
    private _updateNativeEvents;
}
