// this is a polyfill ot the AppRegistry class
'use strict';

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _require = require('react-dom');

var render = _require.render;

var React = require('react');

var AppRegistry = (function () {
	// create a storage

	function AppRegistry() {
		_classCallCheck(this, AppRegistry);

		this.runnables = {};
	}

	// register the config

	_createClass(AppRegistry, [{
		key: 'registerConfig',
		value: function registerConfig(config) {
			for (var i = 0; i < config.length; i++) {
				var appConfig = config[i];
				if (appConfig.run) {
					this.registerRunnable(appConfig.appKey, appConfig.run);
				} else {
					this.registerComponent(appConfig.appKey, appConfig.component);
				}
			}
		}

		// returns the app keys
	}, {
		key: 'getAppKeys',
		value: function getAppKeys() {
			return Object.keys(this.runnables);
		}

		// register a runnable
	}, {
		key: 'registerRunnable',
		value: function registerRunnable(appKey, func) {
			this.runnables[appKey] = func;
			return appKey;
		}

		// register a component
	}, {
		key: 'registerComponent',
		value: function registerComponent(appKey, getComponentFunc) {
			this.runnables[appKey] = {
				run: function run(appParameters) {
					return(
						// TODO: instead of forcing a div with #app, maybe we should allow to configure it
						render(React.createElement(getComponentFunc(), appParameters.initialProps), document.getElementById('app'))
					);
				}
			};
			// TODO: this is temporary, and automatically launch the just added runnable, we should instead auto append it somehow.
			this.runApplication(appKey, {});
			return appKey;
		}
	}, {
		key: 'runApplication',
		value: function runApplication(appKey, appParameters) {
			this.runnables[appKey].run(appParameters);
		}
	}]);

	return AppRegistry;
})();

module.exports = new AppRegistry();